unit fUHFReader188demomain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, Buttons, StdActns, ActnList, DateUtils,ExtCtrls,
  UHFReader188_Head,UHFReader188_DLL_Head,fProgress, IdBaseComponent,
  IdComponent, IdUDPBase, IdUDPServer,IdSocketHandle;
type
  TfrmUHFReader188demomain = class(TForm)
    PageControl1: TPageControl;
    TabSheet_CMD: TTabSheet;
    TabSheet_EPCC1G2: TTabSheet;
    GroupBox_ReaderInfo: TGroupBox;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Edit_Version: TEdit;
    Edit_ComAdr: TEdit;
    Edit_scantime: TEdit;
    Edit_Type: TEdit;
    Button3: TButton;
    Edit_dmaxfre: TEdit;
    Edit_dminfre: TEdit;
    Edit_powerdBm: TEdit;
    Label8: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    GroupBox2: TGroupBox;
    Button5: TButton;
    Label15: TLabel;
    Label16: TLabel;
    GroupBox5: TGroupBox;
    ComboBox_EPC1: TComboBox;
    Button_SetProtectState: TButton;
    GroupBox9: TGroupBox;
    GroupBox10: TGroupBox;
    GroupBox11: TGroupBox;
    ListView_EPC: TListView;
    Label17: TLabel;
    ComboBox_baud: TComboBox;
    Label1: TLabel;
    Edit_NewComAdr: TEdit;
    Label7: TLabel;
    ComboBox_scantime: TComboBox;
    Label5: TLabel;
    Button1: TButton;
    ComboBox_EPC2: TComboBox;
    Label9: TLabel;
    Edit_AccessCode2: TEdit;
    Edit_WriteData: TEdit;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Edit_WordPtr: TEdit;
    Edit_Len: TEdit;
    Button_DestroyCard: TButton;
    Edit_DestroyCode: TEdit;
    Label33: TLabel;
    ComboBox_EPC3: TComboBox;
    Edit_AccessCode1: TEdit;
    Label24: TLabel;
    ActionList1: TActionList;
    Action_GetReaderInformation: TAction;
    Action_OpenCOM: TAction;
    Action_OpenRf: TAction;
    Action_CloseCOM: TAction;
    Action_CloseRf: TAction;
    Action_WriteComAdr: TAction;
    Action_WriteInventoryScanTime: TAction;
    Action_OpenTestMode: TAction;
    Action_CloseTestMode: TAction;
    Action_GetSystemInformation: TAction;
    StatusBar1: TStatusBar;
    Memo_DataShow: TMemo;
    GroupBox1: TGroupBox;
    P_Reserve: TRadioButton;
    P_EPC: TRadioButton;
    P_TID: TRadioButton;
    P_User: TRadioButton;
    GroupBox6: TGroupBox;
    C_Reserve: TRadioButton;
    C_EPC: TRadioButton;
    C_TID: TRadioButton;
    C_User: TRadioButton;
    Action_SetReaderInformation: TAction;
    ComboBox_dminfre: TComboBox;
    ComboBox_dmaxfre: TComboBox;
    Action_SetReaderInformation_0: TAction;
    Timer_Test_: TTimer;
    Action_Inventory: TAction;
    Action_ShowOrChangeData: TAction;
    Action_SetProtectState: TAction;
    Action_DestroyCard: TAction;
    ComboBox_PowerDbm: TComboBox;
    TabSheet_6B: TTabSheet;
    GroupBox12: TGroupBox;
    ListView_ID_6B: TListView;
    Action_Inventroy_6B: TAction;
    Action_Query_6B: TAction;
    Timer_Test_6B: TTimer;
    GroupBox13: TGroupBox;
    Label29: TLabel;
    Label30: TLabel;
    Label31: TLabel;
    ComboBox_ID1_6B: TComboBox;
    Edit_WriteData_6B: TEdit;
    Edit_StartAddress_6B: TEdit;
    Edit_Len_6B: TEdit;
    Memo_DataShow_6B: TMemo;
    Button14: TButton;
    Button15: TButton;
    Action_WriteData_6B: TAction;
    Action_ReadData_6B: TAction;
    Action_LockByte_6B: TAction;
    Action_CheckLock_6B: TAction;
    Button16: TButton;
    Button22: TButton;
    GroupBox14: TGroupBox;
    Label34: TLabel;
    Label28: TLabel;
    Edit_Query_StartAddress_6B: TEdit;
    Edit_ConditionContent_6B: TEdit;
    Less_6B: TRadioButton;
    Different_6B: TRadioButton;
    Same_6B: TRadioButton;
    Greater_6B: TRadioButton;
    Action_Query2_6B: TAction;
    GroupBox16: TGroupBox;
    GroupBox4: TGroupBox;
    DestroyCode: TRadioButton;
    AccessCode: TRadioButton;
    NoProect: TRadioButton;
    Always: TRadioButton;
    Proect: TRadioButton;
    AlwaysNot: TRadioButton;
    Button_DataWrite: TButton;
    Button_BlockErase: TButton;
    Action_ShowOrChangeData_write: TAction;
    Action_ShowOrChangeData_BlockErase: TAction;
    GroupBox17: TGroupBox;
    Label25: TLabel;
    ComboBox_IntervalTime: TComboBox;
    SpeedButton_Query: TSpeedButton;
    GroupBox18: TGroupBox;
    NoProect2: TRadioButton;
    AlwaysNot2: TRadioButton;
    Proect2: TRadioButton;
    Always2: TRadioButton;
    GroupBox19: TGroupBox;
    SpeedButton_Query_6B: TSpeedButton;
   
    GroupBox23: TGroupBox;
    Label38: TLabel;
    Edit_AccessCode3: TEdit;
    Button_WriteEPC_G2: TButton;
    Action_WriteEPC_G2: TAction;
    Edit_WriteEPC: TEdit;
    Label39: TLabel;
    Timer_G2_Alarm: TTimer;
    ComboBox_IntervalTime_6B: TComboBox;
    Label27: TLabel;
    Byone_6B: TRadioButton;
    Bycondition_6B: TRadioButton;
    CheckBox_SameFre: TCheckBox;
    Timer_G2_Read: TTimer;
    SpeedButton_Read_G2: TSpeedButton;
    Timer_6B_ReadWrite: TTimer;
    SpeedButton_Write_6B: TSpeedButton;
    SpeedButton_Read_6B: TSpeedButton;
    EPCC1G2: TCheckBox;
    ISO180006B: TCheckBox;
    GroupBox8: TGroupBox;
    GroupBox3: TGroupBox;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    GroupBox7: TGroupBox;
    RadioButton3: TRadioButton;
    RadioButton4: TRadioButton;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    ComboBox3: TComboBox;
    Button6: TButton;
    GroupBox15: TGroupBox;
    Label26: TLabel;
    Label40: TLabel;
    Label41: TLabel;
    ComboBox4: TComboBox;
    RadioButton5: TRadioButton;
    RadioButton6: TRadioButton;
    GroupBox25: TGroupBox;
    RadioButton7: TRadioButton;
    RadioButton8: TRadioButton;
    GroupBox26: TGroupBox;
    RadioButton9: TRadioButton;
    RadioButton10: TRadioButton;
    RadioButton11: TRadioButton;
    RadioButton12: TRadioButton;
    RadioButton13: TRadioButton;
    Edit1: TEdit;
    ComboBox5: TComboBox;
    Button7: TButton;
    Button8: TButton;
    GroupBox27: TGroupBox;
    RadioButton15: TRadioButton;
    RadioButton14: TRadioButton;
    Memo1: TMemo;
    Timer1: TTimer;
    SpeedButton2: TSpeedButton;
    Button9: TButton;
    GroupBox28: TGroupBox;
    RadioButton_band2: TRadioButton;
    RadioButton_band3: TRadioButton;
    RadioButton_band4: TRadioButton;
    GroupBox29: TGroupBox;
    CheckBox1: TCheckBox;
    Label42: TLabel;
    Edit2: TEdit;
    Edit3: TEdit;
    Label43: TLabel;
    GroupBox30: TGroupBox;
    RadioButton16: TRadioButton;
    RadioButton17: TRadioButton;
    Label44: TLabel;
    ComboBox6: TComboBox;
    RadioButton18: TRadioButton;
    Button_writeblock: TButton;
    GroupBox31: TGroupBox;
    Label52: TLabel;
    Label53: TLabel;
    Edit4: TEdit;
    Edit5: TEdit;
    CheckBox_TID: TCheckBox;
    CheckBox2: TCheckBox;
    Edit_PC: TEdit;
    RadioButton_band5: TRadioButton;
    GroupBox32: TGroupBox;
    ComboBox9: TComboBox;
    Button_relay: TButton;
    ComboBox10: TComboBox;
    Label55: TLabel;
    Label56: TLabel;
    TabSheet2: TTabSheet;
    GroupBox33: TGroupBox;
    ListView1: TListView;
    Button11: TButton;
    Button12: TButton;
    Button13: TButton;
    Button17: TButton;
    Button24: TButton;
    GroupBox34: TGroupBox;
    Label57: TLabel;
    Label58: TLabel;
    Label59: TLabel;
    Label60: TLabel;
    Label61: TLabel;
    IdUDPServer1: TIdUDPServer;
    GroupBox35: TGroupBox;
    GroupBox_COM: TGroupBox;
    Label6: TLabel;
    Label46: TLabel;
    ComboBox_COM: TComboBox;
    Button2: TButton;
    Button4: TButton;
    StaticText1: TStaticText;
    Edit_CmdComAddr: TEdit;
    ComboBox_baud2: TComboBox;
    gp_net: TGroupBox;
    Label62: TLabel;
    Label63: TLabel;
    Label64: TLabel;
    Edit6: TEdit;
    Edit7: TEdit;
    Edit8: TEdit;
    opnet: TButton;
    closenet: TButton;
    RD_Port: TRadioButton;
    RD_Net: TRadioButton;
    IdUDPServer2: TIdUDPServer;
    Label32: TLabel;
    Com_Q: TComboBox;
    Com_S: TComboBox;
    Label35: TLabel;
    Button10: TButton;
    Button18: TButton;
    Label36: TLabel;
    ComboBox7: TComboBox;
    Label37: TLabel;
    ComboBox8: TComboBox;
    Label45: TLabel;
    Edit9: TEdit;
    Label47: TLabel;
    Edit10: TEdit;
    GroupBox20: TGroupBox;
    Edit11: TEdit;
    Button19: TButton;
    procedure FormCreate(Sender: TObject);
    procedure InitComList; //ںųʼб
    procedure InitReaderList;
    procedure ClearLastInfo;
    procedure Action_CloseCOMExecute(Sender: TObject); //رմں,Ӧʾ
    procedure Action_OpenCOMExecute(Sender: TObject);
    procedure Action_GetReaderInformationExecute(Sender: TObject); //򿪴ں
    procedure AddCmdLog(cmd, cmdName: string; cmdRet: Byte; errorCode: LongInt = -1);
    procedure Action_SetReaderInformationExecute(Sender: TObject);
    procedure ComboBox_dfreSelect(Sender: TObject);
    procedure Action_OpenTestModeExecute(Sender: TObject);
    procedure Timer_Test_Timer(Sender: TObject);
    procedure Action_InventoryExecute(Sender: TObject); //״̬ɹʾ
    function getStr(pStr: pchar; len: Integer): string;
    function getHexStr(sBinStr: string): string;
    procedure getCharStr(s:string;cStr: pchar);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure PageControl1Change(Sender: TObject);
    procedure Action_ShowOrChangeDataExecute(Sender: TObject);
    procedure Action_SetProtectStateExecute(Sender: TObject);
    procedure Action_SetProtectStateUpdate(Sender: TObject);
    procedure Action_DestroyCardExecute(Sender: TObject);
    procedure Action_GetReaderInformationUpdate(Sender: TObject);
    procedure ComboBox_IntervalTimeChange(Sender: TObject);
    procedure Edit_NewComAdrKeyPress(Sender: TObject; var Key: Char);
    procedure Timer_G2_Timer(Sender: TObject);
    procedure ComboBox_IntervalTime_6BChange(Sender: TObject);
    procedure Action_Inventory_6BExecute(Sender: TObject);
    procedure Action_Query_6BExecute(Sender: TObject);
    procedure Action_CheckLock_6BExecute(Sender: TObject);
    procedure Action_LockByte_6BExecute(Sender: TObject);
    procedure Button16Click(Sender: TObject);
    procedure Button22Click(Sender: TObject);
    procedure Action_LockUserBlock_G2Execute(Sender: TObject);
    procedure Action_WriteEPC_G2Execute(Sender: TObject);
    procedure CheckBox_SameFreClick(Sender: TObject);
    procedure Timer_G2_ReadTimer(Sender: TObject);
    procedure SpeedButton_ReadWrite_6BClick(Sender: TObject);
    procedure Timer_6B_ReadWriteTimer(Sender: TObject);
    procedure SpeedButton_Read_G2Click(Sender: TObject);
    procedure Action_CheckLock_6BUpdate(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure RadioButton5Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure RadioButton7Click(Sender: TObject);
    procedure RadioButton8Click(Sender: TObject);
    procedure ComboBox4Change(Sender: TObject);
    procedure RadioButton_band2Click(Sender: TObject);
    procedure RadioButton_band3Click(Sender: TObject);
    procedure RadioButton_band4Click(Sender: TObject);
    procedure RadioButton16Click(Sender: TObject);
    procedure RadioButton17Click(Sender: TObject);
    procedure RadioButton9Click(Sender: TObject);
    procedure RadioButton10Click(Sender: TObject);
    procedure RadioButton11Click(Sender: TObject);
    procedure RadioButton12Click(Sender: TObject);
    procedure RadioButton13Click(Sender: TObject);
    procedure RadioButton18Click(Sender: TObject);
    procedure RadioButton19Click(Sender: TObject);
    procedure ComboBox_COMChange(Sender: TObject);
    procedure Button_writeblockClick(Sender: TObject);
    procedure CheckBox_TIDClick(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure Edit_LenKeyPress(Sender: TObject; var Key: Char);
    procedure RadioButton_band5Click(Sender: TObject);
    procedure Edit_WriteDataChange(Sender: TObject);
    procedure C_ReserveClick(Sender: TObject);
    procedure C_TIDClick(Sender: TObject);
    procedure C_UserClick(Sender: TObject);
    procedure C_EPCClick(Sender: TObject);
    procedure Button_relayClick(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure Button17Click(Sender: TObject);
    procedure Button13Click(Sender: TObject);
    procedure Button24Click(Sender: TObject);
    procedure IdUDPServer1UDPRead(Sender: TObject; AData: TStream;
      ABinding: TIdSocketHandle);
    procedure RD_PortClick(Sender: TObject);
    procedure RD_NetClick(Sender: TObject);
    procedure opnetClick(Sender: TObject);
    procedure closenetClick(Sender: TObject);
    procedure IdUDPServer2UDPRead(Sender: TObject; AData: TStream;
      ABinding: TIdSocketHandle);
    procedure Button10Click(Sender: TObject);
    procedure Button18Click(Sender: TObject);
    procedure Button19Click(Sender: TObject);
  private
    { Private declarations }
    fAppClosed: Boolean; //ڲģʽӦرӦó
    fComAdr: Byte; //ǰComAdr
    ComIsOpen:Boolean;
    ferrorcode:LongInt;
    fBaud:Byte;
    fdminfre:Real;
    ISscanstring:Boolean ;
    fdmaxfre:Real;
    maskadr,maskLen,maskFlag:Byte;
    fCmdRet: LongInt; //ִָķֵ
    fOpenComIndex: Integer; //򿪵Ĵ
    fIsInventoryScan: Boolean;
    fisinventoryscan_6B:Boolean;
    fOperEPC: array[0..35] of Char;
    fPassWord:array[0..4] of Char;
    fOperID_6B: array[0..8] of Char;
    fTimer_G2_Alarm: Boolean;
    fTimer_G2_Read:Boolean;
    fTimer_6B_ReadWrite:Boolean;
    breakflag:Boolean;
    x_z,y_f:Real;


  private
    fInventory_EPC_List: string; //ѯбȡûб仯򲻽ˢ£
    fInventory_TID_List: string; //ѯбȡûб仯򲻽ˢ£
    Istemps02Save: boolean;

  public
    { Public declarations }
    fRecvUDPstring:string;
    RemostIP:string;
    IP:string;
    usename:string;
    dsname:string;
    mac:string;
    portnum:string;
    tup:string;
    rm:string;
    cm:string;
    ct:string;
    fc:string;
    dt:string;
    br:string;
    pr:string;
    bb:string;
    rc:string;
    ml:string;
    md:string;
    di:string;
    dp:string;
    gi:string;
    nm:string;
  end;

var
  frmUHFReader188demomain: TfrmUHFReader188demomain;
  frmcomportindex :longint;
implementation

uses locatedlg, ChangeDlg, Setdlg, NhSetDlg, PhSetDlg;


{$R *.dfm}

procedure TfrmUHFReader188demomain.Edit_NewComAdrKeyPress(Sender: TObject;
  var Key: Char);
  var L:Boolean;
begin
    L:=(key<#8)or(key>#8)and(key<#48)or(key>#57)and (key<#65)or(key>#70)and (key<#97)or(key>#102);
    if l then key:=#0;
    if ( (key>#96)and(key<#103))   then  key:=  char(Ord(key)-32) ;
end;

function TfrmUHFReader188demomain.getStr(pStr: pchar; len: Integer): string;
var
  i: Integer;
begin
  result := '';
  for i := 0 to len - 1 do
    result := result + (pStr + i)^;
end;

function TfrmUHFReader188demomain.getHexStr(sBinStr: string): string; //ʮַ
var
  i: Integer;
begin
  result := '';
  for i := 1 to Length(sBinStr) do
    result := result + IntToHex(ord(sBinStr[i]), 2);
end;

procedure TfrmUHFReader188demomain.getCharStr(s:string;cStr: pchar); //ַ
var
  i: Integer;
begin
  try
    for i := 0 to Length(s) div 2-1 do
    (cStr+i)^ := Char(StrToInt('$' + copy(s, i * 2 + 1, 2)));
  except
  end;
end;

procedure TfrmUHFReader188demomain.FormCreate(Sender: TObject);
begin
  fOpenComIndex := -1;
  fComAdr := 0;
  ferrorcode:= -1;
  fBaud:=5;
  InitComList;
  InitReaderList;
  ISscanstring:=False;
  Byone_6B.Checked:=True;
  Different_6B.Checked:=True;
  RadioButton_band3.Checked:=True;

  RadioButton1.Checked :=True;
  RadioButton4.Checked :=True ;
  RadioButton5.Checked :=True ;
  RadioButton7.Checked :=True ;
  RadioButton10.Checked :=True ;
  RadioButton14.Checked :=True ;
  Button6.Enabled:=False;
  Button7.Enabled:=False;
  Button8.Enabled:=False;
  Button9.Enabled:=False;
  SpeedButton2.Enabled:=False;
  ComboBox5.Enabled:=False;
  ComboBox_baud.ItemIndex:=3;
  
  P_EPC.Checked:=True;
  C_EPC.Checked:=True;
  DestroyCode.Checked:=True;
  NoProect.Checked:=True;
  NoProect2.Checked:=True;
  Istemps02Save := false;
  fAppClosed := False;
  Timer_Test_.Enabled := False;
  Timer_Test_6B.Enabled := False;
  Timer_G2_Alarm.Enabled := False;
  Timer_G2_Read.Enabled := False;
  Timer_6B_ReadWrite.Enabled:=False;

  PageControl1.ActivePage := TabSheet_CMD;
  //ģʽʼ
     RadioButton5.Enabled :=False;
   RadioButton6.Enabled :=False;
   RadioButton7.Enabled :=False;
   RadioButton8.Enabled :=False;
   RadioButton9.Enabled :=False;
   RadioButton10.Enabled :=False;
   RadioButton11.Enabled :=False;
   RadioButton12.Enabled :=False;
   RadioButton13.Enabled :=False;
   RadioButton14.Enabled :=False;
   RadioButton15.Enabled :=False;
   Edit1.Enabled:=False;
  // ComboBox5.Enabled:=False;
  RadioButton16.Enabled:=False;
  RadioButton17.Enabled:=False;
  RadioButton18.Enabled:=False;
  RadioButton16.Checked:=True;
  RD_Port.Checked:=True;
  ComboBox_baud2.ItemIndex:=3;
  ComboBox9.ItemIndex:=0;
  ComboBox10.ItemIndex:=0;
end;

procedure TfrmUHFReader188demomain.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  breakflag:=True;
  fAppClosed:=True;
end;

procedure TfrmUHFReader188demomain.InitReaderList;
var
  i:Integer;      
begin

  for i:=$03 to $ff do
  ComboBox_scantime.Items.Add(IntToStr(i)+'*100ms');
  ComboBox_scantime.ItemIndex := 7;
  i:=40;
  while i<=300 do
  begin
  ComboBox_IntervalTime.Items.Add(IntToStr(i)+'ms');
  i:=i+10;
  end;
  ComboBox_IntervalTime.ItemIndex :=1;
  i:=40;
  while i<=300 do
  begin
  ComboBox_IntervalTime_6B.Items.Add(IntToStr(i)+'ms');
  i:=i+10;
  end;
  ComboBox_IntervalTime_6B.ItemIndex :=1;

   for i:= 0 to 255 do
   ComboBox1.Items.Add(IntToStr(i)+'*10ms');
   ComboBox1.ItemIndex :=30;
   for i:= 1 to 255 do
   ComboBox2.Items.Add(IntToStr(i)+'*10us');
   ComboBox2.ItemIndex :=9;
      for i:= 1 to 255 do
   ComboBox3.Items.Add(IntToStr(i)+'*100us');
   ComboBox3.ItemIndex :=14;
   for i:= 0 to 255 do
   ComboBox6.Items.Add(IntToStr(i)+'*1s');
   ComboBox6.ItemIndex :=0;
      for i:= 1 to 32 do
   ComboBox5.Items.Add(IntToStr(i));
   ComboBox5.ItemIndex :=0;
   ComboBox4.ItemIndex :=0;
   ComboBox_PowerDbm.ItemIndex:=30;

   for i:=0 to 15 do
   begin
   Com_Q.Items.Add(IntToStr(i));
   ComboBox7.Items.Add(IntToStr(i));
   end;
   Com_Q.ItemIndex:=4;
   ComboBox7.ItemIndex:=4;
   for i:=0 to 3 do
   begin
   Com_S.Items.Add(IntToStr(i));
   ComboBox8.Items.Add(IntToStr(i));
   end;
   Com_S.ItemIndex:=0;
   ComboBox8.ItemIndex:=0; 

end;
procedure TfrmUHFReader188demomain.InitComList; //ںųʼб
var
  i: Integer;
begin
  ComboBox_COM.Items.Clear;
  ComboBox_COM.Items.Add(' AUTO');
  for i := 1 to 12 do
    ComboBox_COM.Items.Add(' COM' + IntToStr(i));
  ComboBox_COM.ItemIndex := 0;

end;


procedure TfrmUHFReader188demomain.ClearLastInfo;
begin

  Edit_Type.Text := '';
  Edit_Version.Text := '';
  ISO180006B.Checked:=False;
  EPCC1G2.Checked:=False;
  Edit_ComAdr.Text := '';
  Edit_powerdBm.Text := '';
  Edit_scantime.Text := '';
  Edit_dminfre.Text := '';
  Edit_dmaxfre.Text := '';
  PageControl1.TabIndex := 0;
end;

procedure TfrmUHFReader188demomain.Action_CloseCOMExecute(Sender: TObject); //رմں,Ӧʾ
var
port:byte;
SelectCom :string;
begin
  ClearLastInfo;

    if((frmcomportindex>0)and (frmcomportindex<255))then
    begin
      CloseSpecComPort(frmcomportindex);
      ComIsOpen:=False;
      frmcomportindex := -1;
      Button6.Enabled:=False;
      Button7.Enabled:=False;
      Button8.Enabled:=False;
      Button9.Enabled:=False;
      SpeedButton2.Down:=False;
      SpeedButton2.Caption:='Start';
      SpeedButton2.Enabled:=False;
      Timer1.Enabled:=False;
    end;
end;

procedure TfrmUHFReader188demomain.Action_OpenCOMExecute(Sender: TObject); //򿪴ں
var
  port,i: LongInt;
  openresult :byte;
begin
  openresult:=$30;
  Screen.Cursor := crHourGlass;
  if  Edit_CmdComAddr.Text='' then
  Edit_CmdComAddr.Text:='FF';
  fComAdr := StrToInt('$' + Edit_CmdComAddr.Text); // $FF
  try
      if ComboBox_COM.ItemIndex = 0 then //Auto
      begin
        fbaud:=ComboBox_baud2.ItemIndex;
        if fbaud>2 then fbaud:=fbaud+2;
        openresult := AutoOpenComPort(port,fComAdr,fBaud,frmcomportindex);
        fOpenComIndex := frmcomportindex;
        if openresult = 0 then
        begin
           if(fBaud>3)then
              ComboBox_baud.ItemIndex:=fBaud-2
           else
              ComboBox_baud.ItemIndex:=fBaud;
          Action_GetReaderInformationExecute(Sender); //ԶִжȡдϢ

          if (fCmdRet=$35) or (fCmdRet=$30)then
          begin
           Application.MessageBox('Serial Communication Error or Occupied', 'Information', MB_ICONINFORMATION);
           CloseSpecComPort(frmcomportindex) ;
           exit;
          end;
        end;          
      end
      else
      begin
        port := strtoint(copy(ComboBox_COM.items[ComboBox_COM.itemindex],5,2));
        for i:=6 downto 0 do
        begin
          fBaud:=i;
          if(fBaud=3)  or (fBaud=4)then
          Continue;
          openresult := opencomport(port,fComAdr,fBaud,frmcomportindex);
          fOpenComIndex := frmcomportindex;
          if openresult= $35 then
          begin
             Application.MessageBox('COM Opened', 'Information',MB_ICONINFORMATION);
            Exit;
          end;
          if openresult = 0 then
          begin
            if(fBaud>3)then
              ComboBox_baud.ItemIndex:=fBaud-2
            else
              ComboBox_baud.ItemIndex:=fBaud;

            Action_GetReaderInformationExecute(Sender); //ԶִжȡдϢ
            if (fCmdRet=$35) or (fCmdRet=$30)then
            begin
             Application.MessageBox('Serial Communication Error or Occupied', 'Information', MB_ICONINFORMATION);
             CloseSpecComPort(frmcomportindex) ;
            end;
            Break;
          end;
        end;
      end;
  finally
    Screen.Cursor := crDefault;
  end;
                                       
  if (fOpenComIndex <> -1) and
     (openresult <> $35)  and
     (openresult <> $30)  then
  begin
    ComIsOpen:=True;
  end;
  if (fOpenComIndex = -1) and
     (openresult = $30)  then
  begin
    Application.MessageBox('Serial Communication Error', 'Information', MB_ICONINFORMATION);
  end;

end;
procedure TfrmUHFReader188demomain.Action_GetReaderInformationExecute(
  Sender: TObject);
  function getNoStr(no: Integer; noLen: Integer): string;
  begin
    result := intToStr(no);
    while Length(result) < noLen do
      result := '0' + result;
  end;
var
  TrType, VersionInfo: array[0..2] of Char;
  ReaderType, ScanTime,dmaxfre,dminfre,powerdBm,FreBand: Byte;
  i:Integer;
begin
  Edit_Version.Text := '';
  Edit_ComAdr.Text := '';
  Edit_ScanTime.Text := '';
  Edit_Type.text := '';
  ISO180006B.Checked:=False;
  EPCC1G2.Checked:=False;
  Edit_powerdBm.text := '';
  Edit_dminfre.text := '';
  Edit_dmaxfre.text := '';
  ComboBox_PowerDbm.Items.Clear;
  fCmdRet:=GetReaderInformation(fComAdr,@VersionInfo,ReaderType,@TrType, dmaxfre ,dminfre,powerdBm,
                                 ScanTime, frmComPortindex);
  Edit_Version.Text := getnostr(Ord(versioninfo[0]),2)+'.'+getnostr(Ord(versioninfo[1]),2);

    for i:=0 to 30 do
    ComboBox_PowerDbm.Items.Add(IntToStr(i));
    ComboBox_PowerDbm.ItemIndex:=30;

  Edit_ComAdr.Text := IntToHex(fComAdr,2);
  Edit_NewComAdr.Text := IntToHex(fComAdr,2);
  Edit_ScanTime.Text := inttostr(ScanTime)+'*100ms';
  ComboBox_scantime.ItemIndex:= scantime-3;
  Edit_powerdBm.Text   :=IntToStr(powerdBm);
  ComboBox_PowerDbm.ItemIndex:=powerDbm;
 FreBand:= ((dmaxfre and $c0)shr 4)or(dminfre shr 6) ;
 case FreBand of
 $01:begin
       RadioButton_band2.Checked:=True;
       fdminfre := 920.125+(dminfre and $3F)*0.25;
       fdmaxfre := 920.125+(dmaxfre and $3F)*0.25;
     end;
 $02:begin
       RadioButton_band3.Checked:=True;
       fdminfre := 902.75+(dminfre and $3F)*0.5;
       fdmaxfre := 902.75+(dmaxfre and $3F)*0.5;
     end;
 $03:begin
       RadioButton_band4.Checked:=True;
       fdminfre := 917.1+(dminfre and $3F)*0.2;
       fdmaxfre := 917.1+(dmaxfre and $3F)*0.2;
     end;
 $04:begin
       RadioButton_band5.Checked:=True;
       fdminfre := 865.1+(dminfre and $3F)*0.2;
       fdmaxfre := 865.1+(dmaxfre and $3F)*0.2;
     end;
 end;
  Edit_dminfre.Text := FloatToStr(fdminfre)+'MHz';
  Edit_dmaxfre.Text := FloatToStr(fdmaxfre)+'MHz';
  if ((dmaxfre and $3F) <>(dminfre and $3F))then
  CheckBox_SameFre.Checked:=False;
  if(ComboBox_dminfre.Items.Count>0)then
  ComboBox_dminfre.ItemIndex:=dminfre and $3F;
  if(ComboBox_dmaxfre.Items.Count>0)then
  ComboBox_dmaxfre.ItemIndex:=dmaxfre and $3F;
  case ReaderType of
    $06: begin
         Edit_Type.text := '';
         end;

    $0d: begin
         Edit_Type.text := 'UHFReader188';
         end;
  end;
  if (ord(TrType[0]) and $02) = $02 then //ڶֽڵ͵λֵ֧Э顰ISO/IEC 15693
  begin
  EPCC1G2.Checked:=True;
  end
  else
  begin
  EPCC1G2.Checked:=False;
  end;
  if (ord(TrType[0]) and $01) = $01 then //ڶֽڵ͵λֵ֧Э顰ISO/IEC 15693
  begin
  ISO180006B.Checked:=True;
  end
  else
  begin
  ISO180006B.Checked:=False;
  end;
  AddCmdLog('GetReaderInformation','GetReaderInformation', fCmdRet);

end;

procedure TfrmUHFReader188demomain.AddCmdLog(cmd, cmdName: string; cmdRet: Byte; errorCode: LongInt = -1); //״̬ɹʾ
var
  s: string;
begin
  if cmdRet <> 0 then
  begin
    s := ' ' + cmdName + ' Command Response=0x' + IntToHex(cmdRet, 2) + '(' + UHFReader188_GetReturnCodeDesc(cmdRet) + ')';
    if ErrorCode <> -1 then
    begin
        s := s + #13#10 + 'ErrorCode=0x' + IntToHex(ErrorCode, 2) + '(' + UHFReader188_GetErrorCodeDesc(ErrorCode) + ')';
      Application.MessageBox(pchar(s), 'Error Information', MB_ICONINFORMATION);
    end;
  end;
  ferrorcode:=-1;
  if cmdRet = 0 then
    StatusBar1.Panels.Items[0].text := FormatDateTime('hh:mm:ss', Now) + ' ' + cmdName + ' : successfully'
  else
    StatusBar1.Panels.Items[0].text := FormatDateTime('hh:mm:ss', Now) + '' + s;
end;

procedure TfrmUHFReader188demomain.CheckBox_SameFreClick(Sender: TObject);
begin
    if CheckBox_SameFre.Checked then
    ComboBox_dmaxfre.ItemIndex:=ComboBox_dminfre.ItemIndex;
end;

procedure TfrmUHFReader188demomain.Action_SetReaderInformationExecute(
  Sender: TObject);
var
  aNewComAdr,powerDbm,dminfre, dmaxfre ,scantime,band: Byte;
  returninfo:string;
  returninfoDlg:string;
  setinfo:string;
begin
  band:=2;
  frmProgress.Show;
  if(RadioButton_band2.Checked)then
  band:=1;
  if(RadioButton_band3.Checked)then
  band:=2;
  if(RadioButton_band4.Checked)then
  band:=3;
  if(RadioButton_band5.Checked)then
  band:=4;
  frmUHFReader188demomain.Enabled:=False;
  frmProgress.ProgressBar1.Position:=0;
  if Sender = Action_SetReaderInformation then
  begin
    dminfre := ((band and 3)shl 6)or (ComboBox_dminfre.ItemIndex and $3F) ;
    dmaxfre := ((band and $c)shl 4)or (ComboBox_dmaxfre.ItemIndex and $3F) ;
    aNewComAdr := StrToInt('$' + Edit_NewComAdr.Text);
    powerDbm:=ComboBox_PowerDbm.ItemIndex;
    fbaud:=ComboBox_baud.ItemIndex;
    if fbaud>2 then fbaud:=fbaud+2;
    scantime:= ComboBox_scantime.ItemIndex+3;
    setinfo:=' Write';
  end
  else
  begin
    dminfre := 128;
    dmaxfre := 49;
    aNewComAdr :=$00;
    powerDbm:=30 ;
    fbaud:=5;
    scantime:=10;
    setinfo:=' Restore';
    ComboBox_baud.ItemIndex:= 3;
    RadioButton_band3.Checked:=True;
  end;

  frmProgress.ProgressBar1.StepBy(20);
  fCmdRet := WriteComAdr(fComAdr, aNewComAdr,frmcomportindex);
  if fCmdRet=ParameterSaveFailCanUseBeforeNoPower then
  fComAdr := aNewComAdr;
  if fCmdRet = 0 then
  begin
    fComAdr := aNewComAdr;
    returninfo:=returninfo+setinfo+'Address Successfully';
  end
  else if fCmdRet=RecmdErr then
  returninfo:=returninfo+setinfo+'Address Response Command Error'
  else
  begin
  returninfo:=returninfo+setinfo+'Address Fail';
  returninfoDlg:=returninfoDlg+setinfo+'Address Fail Command Response=0x'
       +inttostr(fCmdRet)+'('+UHFReader188_GetReturnCodeDesc(fCmdRet)+')';
  end;

  frmProgress.ProgressBar1.StepBy(20);
  fCmdRet := SetPowerDbm(fComAdr,powerDbm,frmcomportindex);
  if fCmdRet = 0 then
   returninfo:=returninfo+setinfo+'Power Success'
  else if fCmdRet=RecmdErr then
  returninfo:=returninfo+setinfo+'Power Response Command Error'
  else
  begin
  returninfo:=returninfo+setinfo+'Power Fail';
  returninfoDlg:=returninfoDlg+#13#10+setinfo+'Power Fail Command Response=0x'
       +inttostr(fCmdRet)+'('+UHFReader188_GetReturnCodeDesc(fCmdRet)+')';
  end;

  frmProgress.ProgressBar1.StepBy(20);
  fCmdRet := Writedfre(fComAdr,dmaxfre,dminfre,frmcomportindex);
  if fCmdRet = 0 then
   returninfo:=returninfo+setinfo+'Frequency Success'
  else if fCmdRet=RecmdErr then
  returninfo:=returninfo+setinfo+'Frequency Response Command Error'
  else
  begin
  returninfo:=returninfo+setinfo+'Frequency Fail';
  returninfoDlg:=returninfoDlg+#13#10+setinfo+'Frequency Fail Command Response=0x'
       +inttostr(fCmdRet)+'('+UHFReader188_GetReturnCodeDesc(fCmdRet)+')';
  end;

  frmProgress.ProgressBar1.StepBy(20);
  fCmdRet := Writebaud(fComAdr, fBaud,frmcomportindex);
  if fCmdRet = 0 then
   returninfo:=returninfo+setinfo+'Baud Success'
  else if fCmdRet=RecmdErr then
  returninfo:=returninfo+setinfo+'Baud Response Command Error'
  else
  begin
  returninfo:=returninfo+setinfo+'Baud Fail';
  returninfoDlg:=returninfoDlg+#13#10+setinfo+'Baud Fail Command Response=0x'
       +inttostr(fCmdRet)+'('+UHFReader188_GetReturnCodeDesc(fCmdRet)+')';
  end;

  frmProgress.ProgressBar1.StepBy(20);
  fCmdRet := Writescantime(fComAdr, scantime,frmcomportindex);
  if fCmdRet = 0 then
   returninfo:=returninfo+setinfo+'InventoryScanTime Success'
  else if fCmdRet=RecmdErr then
  returninfo:=returninfo+setinfo+'InventoryScanTime Response Command Error'
  else
  begin
  returninfo:=returninfo+setinfo+'InventoryScanTime Fail';
  returninfoDlg:=returninfoDlg+#13#10+setinfo+'InventoryScanTime Fail Command Response=0x'
       +inttostr(fCmdRet)+'('+UHFReader188_GetReturnCodeDesc(fCmdRet)+')';
  end;

  frmProgress.ProgressBar1.StepBy(20);
  Action_GetReaderInformationExecute(Sender);
  frmProgress.Close;
  frmUHFReader188demomain.Enabled:=True;
  StatusBar1.Panels.Items[0].text := FormatDateTime('hh:mm:ss', Now) +  returninfo;
  if  returninfoDlg<>'' then
  MessageDlg(returninfoDlg, mtInformation, [mbOK], 0);
end;

procedure TfrmUHFReader188demomain.ComboBox_dfreSelect(Sender: TObject);
begin
  if CheckBox_SameFre.Checked then
  begin
    if TComboBox(Sender).Tag=1 then
    ComboBox_dminfre.ItemIndex:=ComboBox_dmaxfre.ItemIndex
    else
    ComboBox_dmaxfre.ItemIndex:=ComboBox_dminfre.ItemIndex;
  end
  else if  ComboBox_dminfre.ItemIndex> ComboBox_dmaxfre.ItemIndex  then
  begin
    if TComboBox(Sender).Tag=0 then
    ComboBox_dminfre.ItemIndex:=ComboBox_dmaxfre.ItemIndex
    else
    ComboBox_dmaxfre.ItemIndex:=ComboBox_dminfre.ItemIndex;
    Application.MessageBox('Min.Frequency is equal or lesser than Max.Frequency', 'Error Information', MB_ICONINFORMATION);
  end;
end;

procedure TfrmUHFReader188demomain.PageControl1Change(Sender: TObject);
begin
  if (PageControl1.ActivePage <> TabSheet_EPCC1G2) then
  begin
    Timer_Test_.Enabled := False;
    SpeedButton_Query.Down:=False;
    SpeedButton_Read_G2.Down:=False;
    Timer_G2_Alarm.Enabled:=False;
    Timer_G2_Read.Enabled:=False;
    Timer_6B_ReadWrite.Enabled:=False;
    SpeedButton_Write_6B.Down:=False;
    SpeedButton_Read_6B.Down:=False;
  end;
  if (PageControl1.ActivePage <> TabSheet_6B) then
  begin
    Timer_Test_6B.Enabled := False;
    SpeedButton_Query_6B.Down:=False;
  end;

end;

procedure TfrmUHFReader188demomain.Action_GetReaderInformationUpdate(
  Sender: TObject);
begin
  Button3.Enabled:=ComIsOpen;
  Button5.Enabled:=ComIsOpen;
  Button1.Enabled:=ComIsOpen;
  Button_relay.Enabled:=ComIsOpen;
  Button6.Enabled:=ComIsOpen;
  Button7.Enabled:=ComIsOpen;
  Button8.Enabled:=ComIsOpen;
  Button10.Enabled:=ComIsOpen;
  Button18.Enabled:=ComIsOpen;
  Button19.Enabled:=ComIsOpen;
end;

//EPC 6C G2 Э麯
procedure TfrmUHFReader188demomain.ComboBox_IntervalTimeChange(Sender: TObject);
begin
  if   ComboBox_IntervalTime.ItemIndex<6  then
    Timer_Test_.Interval :=100
  else
    Timer_Test_.Interval :=(ComboBox_IntervalTime.ItemIndex+4)*10;
end;

procedure TfrmUHFReader188demomain.Action_OpenTestModeExecute(Sender: TObject);
begin
  if(CheckBox_TID.Checked)then
  begin
    if(Length(Edit4.Text)<>2)or(Length(Edit5.Text)<>2)then
    begin
     StatusBar1.Panels[0].Text:='TID Parameter Error';
     SpeedButton_Query.down:=False;
     Exit;
    end;
  end;
  if not (SpeedButton_Query.down) then
  begin
    AddCmdLog('Inventory', 'Exit Query', 0);
    Timer_Test_.Enabled:=False;
    Edit4.Enabled:=true;
    Edit5.Enabled:=true;
    CheckBox_TID.Enabled:=True;
    ComboBox7.Enabled:=True;
    ComboBox8.Enabled:=True;
  end
  else
  begin
    fInventory_EPC_List := ''; //ԭĻ
    ListView_EPC.Items.Clear;
    Timer_Test_.Enabled:=True;
    ListView_EPC.Clear;
    ComboBox_EPC1.Clear;
    ComboBox_EPC2.Clear;
    ComboBox_EPC3.Clear;
    CheckBox1.Checked:=False;
    Edit4.Enabled:=False;
    Edit5.Enabled:=False;
    CheckBox_TID.Enabled:=False;
    ComboBox7.Enabled:=False;
    ComboBox8.Enabled:=False;
  end;
end;

procedure TfrmUHFReader188demomain.Timer_Test_Timer(Sender: TObject);
begin
    if fisinventoryscan then    Exit;
    Action_inventoryExecute(sender);

end;

procedure TfrmUHFReader188demomain.Action_InventoryExecute(Sender: TObject);
  procedure ChangeSubItem1(aListItem: TListItem; subItemIndex: Integer; ItemText: string;RSSI:string);
  begin
    if aListItem.SubItems[subItemIndex] = ItemText then
    begin
      if (aListItem.SubItems[2]='99999') or (aListItem.SubItems[2]='')then              //aListItem.SubItems[2]Ϊ
       aListItem.SubItems[2]:='0'                        //aListItem.SubItems[0]Ϊ EPC
       
      else
      begin
       aListItem.SubItems[2]:= IntToStr(StrToInt(aListItem.SubItems[2])+1);
       aListItem.SubItems[3]:=RSSI;
       exit; //ͬҪ޸ģԲ˸
      end;
    end;
    aListItem.SubItems[2]:='1';
    aListItem.SubItems[3]:=RSSI;
    aListItem.SubItems[subItemIndex] := ItemText;

  end;
  procedure ChangeSubItem2(aListItem: TListItem; subItemIndex: Integer; ItemText,RSSI: string);
  begin
    if aListItem.SubItems[subItemIndex] = ItemText then         //aListItem.SubItems[1]Ϊ EPC
    exit; //ͬҪ޸ģԲ˸
    aListItem.SubItems[subItemIndex] := ItemText;
  end;
var
  i, j,CardNum,EPClen,m,Totallen,CardIndex:Integer;
  EPC: array[0..265535] of Char;
  isonlistview,isonstring:Boolean;
  s,ss, sEPC,RSSI,temps: string;
  aListItem: TListItem;
  Qvalue,Session,AdrTID,LenTID,TIDFlag:Byte;
  lastepc:string;
begin
  if(CheckBox_TID.Checked)then
  begin
    AdrTID:=StrToInt('$'+Trim(Edit4.Text));
    LenTID:=StrToInt('$'+Trim(Edit5.Text));
    TIDFlag:=1;
  end
  else
  begin
    AdrTID:=0;
    LenTID:=0;
    TIDFlag:=0;
  end;
  Qvalue:=ComboBox7.ItemIndex;
  Session:=ComboBox8.ItemIndex;
  fIsInventoryScan := true;
  try
  fCmdRet :=Inventory_G2(fComAdr,Qvalue,Session,AdrTID,LenTID,TIDFlag,@EPC,Totallen,CardNum,frmcomportindex);
    if  (fCmdRet = $01)or (fCmdRet = $02)or (fCmdRet = $03)or (fCmdRet = $04)or(fCmdRet = $FB)  then //Ѳҽз仯
    begin
       temps :=getStr(EPC,Totallen);
      begin
        fInventory_EPC_List := tempS;            //¼
          m:=1;
        for CardIndex := 1 to CardNum do
        begin
            EPClen:=ord(tempS[m])+2;
            sEPC := copy(tempS,m,EPClen) ;
            m:=m+EPClen;
            if Length(sEPC) <> EPClen then Continue;
            s := getHexStr(sEPC);
            RSSI:= IntToStr(StrToInt('$'+copy(s,Length(s)-1,2)));
          isonlistview:=False;
          for i:=1 to ListView_EPC.Items.Count do      //жǷListviewб
          begin
            if copy(s, 3, Length(s)-4)=(ListView_EPC.Items[i - 1]).SubItems[0] then
            begin
             aListItem := ListView_EPC.Items[i - 1];
             isonlistview:=True;
            end;
          end;
          if (not isonlistview) then
          begin
            aListItem := ListView_EPC.Items.Add;
            aListItem.Caption := IntToStr(aListItem.Index + 1);
            aListItem.SubItems.Add('');
            aListItem.SubItems.Add('');
            aListItem.SubItems.Add('');
            aListItem.SubItems.Add('');
            aListItem.SubItems.Add('');
            aListItem := ListView_EPC.Items[ListView_EPC.Items.Count - 1];
            ChangeSubItem2(aListItem, 1, IntToHex(ord(sEPC[1]), 2),RSSI);
            if(not CheckBox_TID.Checked)then
            begin
              ComboBox_EPC1.Items.Add(copy(s, 3, Length(s)-4));
              ComboBox_EPC2.Items.Add(copy(s, 3, Length(s)-4));
              ComboBox_EPC3.Items.Add(copy(s, 3, Length(s)-4));

            end;
          end;
          ChangeSubItem1(aListItem, 0, copy(s, 3, Length(s)-4),RSSI);
          if(not CheckBox_TID.Checked)then
          begin
            ComboBox_EPC1.Itemindex:=0;
            ComboBox_EPC2.Itemindex:=0;
            ComboBox_EPC3.Itemindex:=0;
          end;

          if(s<>'')then lastepc:=copy(s, 3, Length(s)-4);
          if(ListView_EPC.Items.Count>0)then
          begin
            Edit10.Text:=IntToStr(ListView_EPC.Items.Count);
            Edit9.Text:= lastepc;
            ListView_EPC.ItemIndex := ListView_EPC.Items.Count -1;
            ListView_EPC.Selected.MakeVisible(False);
          end;

        end;
      end;
    end;
    if Timer_Test_.Enabled then
    begin
        if  fCmdRet<>0 then
        AddCmdLog('Inventory', 'Inventory', fCmdRet);
    end;
  finally
     fIsInventoryScan := False;
  end;
  if fAppClosed then Close;
end;

procedure TfrmUHFReader188demomain.SpeedButton_Read_G2Click(Sender: TObject);
begin
  if SpeedButton_Read_G2.Down  then
  begin
    if Length(Edit_AccessCode2.Text)<8 then
    begin
      SpeedButton_Read_G2.Down:=False;
      MessageDlg('Access Password Less Than 8 digit!Please input again!', mtInformation, [mbOK], 0);
      Exit;
    end;
    if (Edit_WordPtr.Text='')or (Edit_Len.Text='')then
    begin
      SpeedButton_Read_G2.Down:=False;
      MessageDlg('Start address or length is empty!Please input!', mtInformation, [mbOK], 0);
      Exit;
    end;
  Timer_G2_Read.Enabled:=True;
  end
  else
  begin
  Timer_G2_Read.Enabled:=False;
  StatusBar1.Panels.Items[0].text := FormatDateTime('hh:mm:ss', Now) +  ' "Read" over' ;
  end;
end;

procedure TfrmUHFReader188demomain.Timer_G2_ReadTimer(Sender: TObject);
var
    Mem,Num,WordPtr:Byte;
    EPClength:byte;
    i: Integer;
    s2: string;
    CardData: array[0..320] of Char;
begin
  if  fTimer_G2_Read then    exit;
  fTimer_G2_Read:=true;
  try
    if SpeedButton_Read_G2.Down  then
    begin
      if(edit2.Text='')or(edit3.Text='')then
      Exit;
      if CheckBox1.Checked then
        maskFlag:=1
      else
        maskFlag:=0;
      maskadr:=StrToInt('$'+edit2.Text);
      maskLen:=StrToInt('$'+edit3.Text);
      getCharStr(ComboBox_EPC2.text,fOperEPC);
      getCharStr(Edit_AccessCode2.text,fPassword);
      EPClength:=Length(ComboBox_EPC2.text) div 2;
      WordPtr:=StrToInt('$'+Edit_WordPtr.Text);
      Num:=StrToInt(Edit_Len.Text);
      if  C_Reserve.Checked then
        Mem:=0
      else if  C_EPC.Checked then
        Mem:=1
      else if  C_TID.Checked then
        Mem:=2
      else if  C_User.Checked then
        Mem:=3;
      fCmdRet:=ReadCard_G2(fComAdr,@fOperEPC,Mem,WordPtr,Num,@fPassword,maskadr,maskLen,maskFlag,@CardData,EPClength,ferrorcode,frmComPortindex);
      if fCmdRet=0 then
      begin
        for i := 0 to Num*2 - 1 do
        s2 := s2 + IntToHex(ord(CardData[i]), 2);
        Memo_DataShow.Lines.Add(s2);
      end;
      if  fErrorCode<>-1 then
      begin
      StatusBar1.Panels.Items[0].text := FormatDateTime('hh:mm:ss', Now) +
       ' "Read" Response ErrorCode=0x'+ IntToHex(fErrorCode, 2) +
       '(' + UHFReader188_GetErrorCodeDesc(fErrorCode) + ')';
        ferrorcode:=-1;
      end
      else      
      AddCmdLog('ReadData','Read', fCmdRet);
      if not (SpeedButton_Read_G2.Down)  then
      StatusBar1.Panels.Items[0].text := FormatDateTime('hh:mm:ss', Now) +  ' "Read" over' ;
    end;
  finally
  fTimer_G2_Read:=false;
  end;
  if fAppClosed then Close;
end;

procedure TfrmUHFReader188demomain.Action_ShowOrChangeDataExecute(
  Sender: TObject);
var
    Mem,Num,WordPtr:Byte;
    Writedata:array[0..320] of Char;
    Writedatalen:byte;
    EPClength:byte;
    i: Integer;
    s,s2: string;
    CardData: array[0..320] of Char;
    WrittenDataNum:LongInt;
begin
    if(edit2.Text='')or(edit2.Text='')then
    Exit;
    if CheckBox1.Checked then
      maskFlag:=1
    else
      maskFlag:=0;
    maskadr:=StrToInt('$'+edit2.Text);
    maskLen:=StrToInt('$'+edit3.Text);
    if Length(Edit_AccessCode2.Text)<8 then
    begin
      MessageDlg('Access Password Less Than 8 digit!Please input again!', mtInformation, [mbOK], 0);
      Exit;
    end;
    if (Edit_WordPtr.Text='')or (Edit_Len.Text='')then
    begin
      MessageDlg('Start address or length is empty!Please input!', mtInformation, [mbOK], 0);
      Exit;
    end;
    getCharStr(ComboBox_EPC2.text,fOperEPC);
    getCharStr(Edit_AccessCode2.text,fPassword);
    EPClength:=Length(ComboBox_EPC2.text) div 2;
    WordPtr:=StrToInt('$'+Edit_WordPtr.Text);
    Num:=StrToInt(Edit_Len.Text);
    if  C_Reserve.Checked then
      Mem:=0
    else if  C_EPC.Checked then
      Mem:=1
    else if  C_TID.Checked then
      Mem:=2
    else if  C_User.Checked then
      Mem:=3;
    if Sender=Action_ShowOrChangeData_write then
    begin
      if ( Edit_WriteData.Text='' )or (Length(Edit_WriteData.Text)mod 4<>0) then
      begin
      MessageDlg('Please input Data in words in hexadecimal form!'+#13+#10+'For example: 123412345678', mtInformation, [mbOK], 0);
      Exit;
      end;
      Writedatalen:= Length(Edit_WriteData.text)div 2 ;
      getCharStr(Edit_WriteData.text,Writedata);
       if(CheckBox2.Checked)and(C_EPC.Checked)then
      begin
       WordPtr:=1;
       Writedatalen:= Length(Edit_WriteData.text)div 2 +2;
       getCharStr(edit_pc.Text+Edit_WriteData.text,Writedata);
      end;
      fCmdRet:=WriteCard_G2(fComAdr,@fOperEPC,Mem,WordPtr,Writedatalen,@Writedata,@fPassword,maskadr,maskLen,maskFlag,WrittenDataNum,EPClength,ferrorcode,frmComPortindex);
      AddCmdLog('WriteData','Write', fCmdRet,ferrorcode);
      if fCmdRet=0 then
      begin
      StatusBar1.Panels.Items[0].text := FormatDateTime('hh:mm:ss', Now) +  ' "Write"Command Response=0x00' +
                  '(completely write Data successfully)';
      end;
    end;
    if Sender=Action_ShowOrChangeData_BlockErase then
    begin
      if Length(Edit_AccessCode2.Text)<8 then
      begin
       MessageDlg('Access Password Less Than 8 digit!Please input again!', mtInformation, [mbOK], 0);
        Exit;
      end;
      if (Edit_WordPtr.Text='')or (Edit_Len.Text='')then
      begin
       SpeedButton_Read_G2.Down:=False;
         MessageDlg('Start address or Length of Block erase is empty!Please input!', mtInformation, [mbOK], 0);
        Exit;
      end;
      if (strtoint('$'+Edit_WordPtr.Text)<1 )and C_EPC.checked then
      begin
         MessageDlg('the length of start Address of erasing EPC area is equal or greater than 0x01!', mtInformation, [mbOK], 0);
        Exit;
      end;
      fCmdRet:=EraseCard_G2(fComAdr,@fOperEPC,Mem,WordPtr,Num,@fPassword,maskadr,maskLen,maskFlag,EPClength,ferrorcode,frmComPortindex);
      AddCmdLog('EraseCard', 'Erase data', fCmdRet,ferrorcode);
      if fCmdRet=0 then
      begin
      StatusBar1.Panels.Items[0].text := FormatDateTime('hh:mm:ss', Now) +  ' "Block Erase"Command Response=0x00' +
                '(Block Erase successfully)';
      end;
    end;
end;

procedure TfrmUHFReader188demomain.Button16Click(Sender: TObject);
begin
 Memo_DataShow.Clear;
end;

procedure TfrmUHFReader188demomain.Action_SetProtectStateExecute(Sender: TObject);
var
  select:byte;
  setprotect:Byte;
  return:Integer;
  EPClength:Byte;
begin
  if(edit2.Text='')or(edit2.Text='')then
    Exit;
    if CheckBox1.Checked then
      maskFlag:=1
      else
      maskFlag:=0;
      maskadr:=StrToInt('$'+edit2.Text);
      maskLen:=StrToInt('$'+edit3.Text);
    getCharStr(ComboBox_EPC1.text,fOperEPC);
    EPClength:=Length(ComboBox_EPC1.text) div 2;
    getCharStr(Edit_AccessCode1.text,fPassword);
    if P_Reserve.Checked and DestroyCode.Checked  then
     select:=$00
    else if P_Reserve.Checked and AccessCode.Checked then
     select:=$01
    else if P_EPC.Checked then
     select:=$02
    else if P_TID.Checked then
     select:=$03
    else if P_User.Checked then
     select:=$04;
    if P_Reserve.Checked then
    begin
      if NoProect.Checked then
       setprotect:=$00
      else if Proect.Checked then
       setprotect:=$02
      else if Always.Checked then
      begin
       setprotect:=$01;
       return:=MessageDlg('Set permanently readable and writeable Confirmed?', mtInformation, [mbOK, mbCancel], 0);
       if return = IDCancel then
       Exit;
      end
      else if AlwaysNot.Checked then
      begin
       setprotect:=$03;
       return:=MessageDlg('Set never readable and writeable Confirmed?', mtInformation, [mbOK, mbCancel], 0);
       if return = IDCancel then
       Exit;
      end;
    end
    else
    begin
      if NoProect2.Checked then
       setprotect:=$00
      else if Proect2.Checked then
       setprotect:=$02
      else if Always2.Checked then
      begin
       setprotect:=$01;
      return:=MessageDlg('Set permanently writeable Confirmed?', mtInformation, [mbOK, mbCancel], 0);
       if return = IDCancel then
       Exit;
      end
      else if AlwaysNot2.Checked then
      begin
       setprotect:=$03;
       return:=MessageDlg('Set never writeable Confirmed?', mtInformation, [mbOK, mbCancel], 0);
       if return = IDCancel then
       Exit;
      end;
    end;
    if Length(Edit_AccessCode1.Text)<8 then
    begin
     MessageDlg('Access Password Less Than 8 digit!Please input again!', mtInformation, [mbOK], 0);
      Exit;
    end;
    fCmdRet:=SetCardProtect_G2(fComAdr,@fOperEPC,select,setprotect,@fPassword,maskadr,maskLen,maskFlag,EPClength,ferrorcode,frmComPortindex);  ;
    AddCmdLog('SetCardProtect', 'SetProtect', fCmdRet,ferrorcode);
end;

procedure TfrmUHFReader188demomain.Action_SetProtectStateUpdate(Sender: TObject);
var
  CanEnabled:Boolean;
  CanEnabled2:Boolean;
begin
    SpeedButton_Query .Enabled:=ComIsOpen  and (not (SpeedButton_Read_G2.Down) ) ;
    CanEnabled:=not (SpeedButton_Query.down) and  ComIsOpen and (ListView_EPC.Items.Count<>0)
                and  (not (SpeedButton_Read_G2.Down) );
    CanEnabled2:=not (SpeedButton_Query.down) and  ComIsOpen
               and (not (SpeedButton_Read_G2.Down) );
    ComboBox_IntervalTime.Enabled:= CanEnabled2;

    AccessCode.Enabled:=CanEnabled and (P_Reserve.Checked) ;
    DestroyCode.Enabled:=CanEnabled and (P_Reserve.Checked) ;
    NoProect.Enabled:=CanEnabled and (P_Reserve.Checked) ;
    Proect.Enabled:=CanEnabled and (P_Reserve.Checked) ;
    Always.Enabled:=CanEnabled and (P_Reserve.Checked) ;
    AlwaysNot.Enabled:=CanEnabled and (P_Reserve.Checked) ;

    NoProect2.Enabled:=not (P_Reserve.Checked)and CanEnabled;
    Proect2.Enabled:=not (P_Reserve.Checked)and CanEnabled;
    Always2.Enabled:=not (P_Reserve.Checked)and CanEnabled;
    AlwaysNot2.Enabled:=not (P_Reserve.Checked)and CanEnabled;

    GroupBox5.Enabled:=CanEnabled;
    Label24.Enabled:=CanEnabled;
    ComboBox_EPC1.Enabled:=CanEnabled;
    GroupBox18.Enabled:=CanEnabled;

    Edit_AccessCode1.Enabled:=CanEnabled;
    GroupBox1.Enabled:=CanEnabled;
    P_Reserve.Enabled:=CanEnabled;
    P_EPC.Enabled:=CanEnabled;
    P_TID.Enabled:=CanEnabled;
    P_User.Enabled:=CanEnabled;
    GroupBox9.Enabled:=CanEnabled;
    Label33.Enabled:=CanEnabled;
    Edit_DestroyCode.Enabled:=CanEnabled;
    ComboBox_EPC3.Enabled:=CanEnabled;

    GroupBox10.Enabled:=not (SpeedButton_Query.down) and  ComIsOpen and (ListView_EPC.Items.Count<>0);
    SpeedButton_Read_G2.Enabled:=GroupBox10.Enabled ;
    Memo_DataShow.Enabled:=GroupBox10.Enabled ;
    Button16.Enabled:=GroupBox10.Enabled ;
    
    Label9.Enabled:=CanEnabled;
    Label18.Enabled:=CanEnabled;
    Label19.Enabled:=CanEnabled;
    Label20.Enabled:=CanEnabled;
    ComboBox_EPC2.Enabled:=CanEnabled;
    Edit_AccessCode2.Enabled:=CanEnabled;
    Edit_WriteData.Enabled:=CanEnabled;
    Edit_WordPtr.Enabled:=CanEnabled;
    Edit_Len.Enabled:=CanEnabled;

    CheckBox1.Enabled:=CanEnabled;
    if CheckBox1.Checked then
    begin
      edit2.Enabled:=True;
      Edit3.Enabled:=True;
    end
    else
    begin
      edit2.Enabled:=False;
      Edit3.Enabled:=False;
    end;
    GroupBox6.Enabled:=CanEnabled;
    C_Reserve.Enabled:=CanEnabled;
    C_EPC.Enabled:=CanEnabled;
    C_TID.Enabled:=CanEnabled;
    C_User.Enabled:=CanEnabled;
    Button_SetProtectState.Enabled:=CanEnabled;

    Button_DataWrite.Enabled:=CanEnabled ;
    Button_BlockErase.Enabled:=CanEnabled;
    Button_DestroyCard.Enabled:=CanEnabled;

    GroupBox23.Enabled:=CanEnabled2;
    Label38.Enabled:=CanEnabled2;
    Label39.Enabled:=CanEnabled2;
    Edit_AccessCode3.Enabled:=CanEnabled2;
    Button_WriteEPC_G2.Enabled:=CanEnabled2;
    Edit_WriteEPC.Enabled:=CanEnabled2;
    Button_writeblock.Enabled:=CanEnabled;

end;

procedure TfrmUHFReader188demomain.Action_DestroyCardExecute(Sender: TObject);
var
  return:Integer;
  EPClength:byte;
begin
  if(edit2.Text='')or(edit2.Text='')then
    Exit;
  if CheckBox1.Checked then
    maskFlag:=1
  else
    maskFlag:=0;
  maskadr:=StrToInt('$'+edit2.Text);
  maskLen:=StrToInt('$'+edit3.Text);
  return:=MessageDlg('Kill the Tag  Confirmed?', mtInformation, [mbOK, mbCancel], 0);
  if return = IDok then
  begin
    if Length(Edit_DestroyCode.Text)<8 then
    begin
      MessageDlg('Kill Password Less Than 8 digit!Please input again!', mtInformation, [mbOK], 0);
      Exit;
    end;
    EPClength:=Length(ComboBox_EPC3.text) div 2;
    getCharStr(ComboBox_EPC3.text,fOperEPC);
    getCharStr(Edit_DestroyCode.text,fPassword);
    fCmdRet:=DestroyCard_G2(fComAdr,@fOperEPC,@fPassword,maskadr,maskLen,maskFlag,EPClength,ferrorcode,frmComPortindex);
    AddCmdLog('DestroyCard', 'Kill Tag', fCmdRet,ferrorcode);
    if fCmdRet=0 then
    begin
    StatusBar1.Panels.Items[0].text := FormatDateTime('hh:mm:ss', Now) +  ' "Kill Tag"Command Response=0x00' +
              '(Kill successfully)'
    end;
  end;
end;

procedure TfrmUHFReader188demomain.Action_WriteEPC_G2Execute(Sender: TObject);
var
  EPClength:byte;
  WriteEPC:array[0..100] of Char;
  WriteEPClen:Byte;
begin
  if Length(Edit_AccessCode3.Text)<8 then
  begin
     MessageDlg('Access Password Less Than 8 digit!Please input again!', mtInformation, [mbOK], 0);
    Exit;
  end;
  if (Length(Edit_WriteEPC.Text)mod 4<>0) then
  begin
  MessageDlg('Please input Data in words in hexadecimal form!'+#13+#10+'For example: 123412345678', mtInformation, [mbOK], 0);
  Exit;
  end;
  WriteEPClen:= Length(Edit_WriteEPC.text)div 2 ;
  getCharStr(Edit_WriteEPC.text,WriteEPC);
  getCharStr(Edit_AccessCode3.text,fPassword);
  fCmdRet:=WriteEPC_G2(fComAdr,@fPassword,@WriteEPC,WriteEPClen,ferrorcode,frmComPortindex);
  AddCmdLog('WriteEPC_G2', 'Write EPC', fCmdRet,ferrorcode);
  if fCmdRet=0 then
  begin
  StatusBar1.Panels.Items[0].text := FormatDateTime('hh:mm:ss', Now) +  ' "Write EPC"Command Response=0x00' +
            '(Write EPC successfully)'
  end;
end;


procedure TfrmUHFReader188demomain.Action_LockUserBlock_G2Execute(Sender: TObject);
begin

end;
//18000-6B Э麯

procedure TfrmUHFReader188demomain.Action_Query_6BExecute(Sender: TObject);
var
   i:   Integer;
begin
    if not (SpeedButton_Query_6B.down) then
    begin
      AddCmdLog('Inventory', 'Exit query', 0);
      Timer_Test_6B.Enabled:=False;
    end
    else
    begin
      if Bycondition_6B.Checked then
      begin
        if (Edit_Query_StartAddress_6B.Text='') or (Edit_ConditionContent_6B.Text='') then
        begin
        MessageDlg('Start address or condition is empty!Please input!', mtInformation, [mbOK], 0);
        SpeedButton_Query_6B.down:=False;
          Exit;
        end;
      end;
      Timer_Test_6B.Enabled:=True;
      ListView_ID_6B.Clear;
      ComboBox_ID1_6B.Clear;
    end;
end;

procedure TfrmUHFReader188demomain.Timer_G2_Timer(Sender: TObject);
begin
    if fisinventoryscan_6B then    Exit;
    Action_inventory_6BExecute(sender);
end;

procedure TfrmUHFReader188demomain.Action_Inventory_6BExecute(Sender: TObject);
  procedure ChangeSubItem1(aListItem: TListItem; subItemIndex: Integer; ItemText: string);
  begin
    if aListItem.SubItems[subItemIndex] = ItemText then
    begin
      if (aListItem.SubItems[1]='99999') or (aListItem.SubItems[1]='')then              //aListItem.SubItems[2]Ϊ
       aListItem.SubItems[1]:='0'                        //aListItem.SubItems[0]Ϊ EPC
      else
      begin
       aListItem.SubItems[1]:= IntToStr(StrToInt(aListItem.SubItems[1])+1);
       exit; //ͬҪ޸ģԲ˸
      end;
    end;
    aListItem.SubItems[1]:='1';
    aListItem.SubItems[subItemIndex] := ItemText;

  end;
  procedure ChangeSubItem2(aListItem: TListItem; subItemIndex: Integer; ItemText: string);
  begin
    if aListItem.SubItems[subItemIndex] = ItemText then         //aListItem.SubItems[1]Ϊ EPC
    exit; //ͬҪ޸ģԲ˸
    aListItem.SubItems[subItemIndex] := ItemText;
  end;
var
  CardNum:Integer;
  EPClen,m,Totallen:Integer;
  ID_6B: array[0..2000] of Char;
  ID2_6B: array[0..5000] of Char;
  isonstring:Boolean;
  isonlistview:Boolean;
  CardIndex: Integer;
  temps: string;
  s,ss, sID: string;
  aListItem: TListItem;
  temps2, temps3: string;
  i, j: integer;
  Condition:Byte;
  StartAddress,mask:Byte;
  ConditionContent:array[0..300] of Char;
  Contentlen:Byte;
begin
  fIsInventoryScan_6B := true;
  try
    if Byone_6B.Checked then
    begin
    fCmdRet :=inventory_6B(fComAdr,@ID_6B,frmcomportindex);
      if  fCmdRet = $00  then //Ѳҽз仯
      begin
        temps :=getStr(ID_6B,8);
        begin
            s := getHexStr(temps);
            isonlistview:=False;
            for i:=1 to ListView_ID_6B.Items.Count do      //жǷListviewб
            begin
              if s=(ListView_ID_6B.Items[i - 1]).SubItems[0] then
              begin
               aListItem := ListView_ID_6B.Items[i - 1];
               isonlistview:=True;
              end;
            end;
            if (not isonlistview) then
            begin
              aListItem := ListView_ID_6B.Items.Add;
              aListItem.Caption := IntToStr(aListItem.Index + 1);
              aListItem.SubItems.Add('');
              aListItem.SubItems.Add('');
              aListItem.SubItems.Add('');
              aListItem.SubItems.Add('');
              aListItem := ListView_ID_6B.Items[ListView_ID_6B.Items.Count - 1];
              ComboBox_ID1_6B.Items.Add(s);
            end;
              ChangeSubItem1(aListItem, 0, S);
              ComboBox_ID1_6B.Itemindex:=0;
        end;
      end;
    end
    else if Bycondition_6B.Checked then
    begin
      if  Same_6B.Checked then
      Condition:=$00
      else if Different_6B.Checked then
      Condition:=$01
      else if Greater_6B.Checked  then
      Condition:=$02
      else if Less_6B.Checked then
      Condition:=$03;
      ss:=Edit_ConditionContent_6B.text;
      Contentlen:=Length(Edit_ConditionContent_6B.text) ;
      for i:=1 to 16-Contentlen do
      ss:=ss+'0';
      getCharStr(ss,ConditionContent);
      case (Contentlen div 2) of
        1: mask:=$80;
        2: mask:=$C0;
        3: mask:=$E0;
        4: mask:=$F0;
        5: mask:=$F8;
        6: mask:=$FC;
        7: mask:=$FE;
        8: mask:=$FF;
      end;
      StartAddress:= StrToInt(Edit_Query_StartAddress_6B.Text);
      fCmdRet :=inventory2_6B(fComAdr,Condition,StartAddress,mask,@ConditionContent,@ID2_6B,Cardnum,frmcomportindex);
      if  (fCmdRet = $15)or (fCmdRet = $16)or (fCmdRet = $17)or (fCmdRet = $18)or(fCmdRet = $FB)    then
      begin
        temps :=getStr(ID2_6B,Cardnum*8);
        begin
          fInventory_EPC_List := tempS;            //¼
            m:=1;
          for CardIndex := 1 to CardNum do
          begin
              sID := copy(tempS,m,8) ;
              m:=m+8;
              if Length(sID) <> 8 then Continue;
              s := getHexStr(sID);
            isonlistview:=False;
            for i:=1 to ListView_ID_6B.Items.Count do      //жǷListviewб
            begin
              if copy(s, 1, Length(s))=(ListView_ID_6B.Items[i - 1]).SubItems[0] then
              begin
               aListItem := ListView_ID_6B.Items[i - 1];
               isonlistview:=True;
              end;
            end;
            if (not isonlistview) then
            begin
              aListItem := ListView_ID_6B.Items.Add;
              aListItem.Caption := IntToStr(aListItem.Index + 1);
              aListItem.SubItems.Add('');
              aListItem.SubItems.Add('');
              aListItem.SubItems.Add('');
              aListItem.SubItems.Add('');
              aListItem.SubItems.Add('');
              aListItem := ListView_ID_6B.Items[ListView_ID_6B.Items.Count - 1];
              ComboBox_ID1_6B.Items.Add(copy(s, 1, Length(s)));
            end;
            ChangeSubItem1(aListItem, 0, copy(s, 1, Length(s)));
            ComboBox_ID1_6B.Itemindex:=0;
          end;
        end;
      end;
    end;
    if Timer_Test_6B.Enabled then
    begin
      if Bycondition_6B.Checked then
      begin
        if  fCmdRet<>0 then
        AddCmdLog('Inventory', 'Query tag', fCmdRet);
      end
      else if fCmdRet = $FB then //˵δпȡ
      begin

          StatusBar1.Panels.Items[0].text := FormatDateTime('hh:mm:ss', Now) + ' "Query Tag"Command Response=0xFB' +
               '(No Tag Operable)'
      end
      else if fCmdRet = $00 then
          StatusBar1.Panels.Items[0].text := FormatDateTime('hh:mm:ss', Now) +  ' "Query Tag"Command Response=0x00' +
               '(Find a Tag)'
      else
         AddCmdLog('Inventory', 'Query Tag', fCmdRet);
      if fCmdRet=RecmdErr then
      StatusBar1.Panels.Items[0].text := FormatDateTime('hh:mm:ss', Now) +  ' "Query Tag"Command Response=0xee' +
                    '(Response Command Error)' ;
    end;
  finally
     fIsInventoryScan_6B := False;
  end;
  if fAppClosed then Close;
end;


procedure TfrmUHFReader188demomain.ComboBox_IntervalTime_6BChange(
  Sender: TObject);
begin
  if   ComboBox_IntervalTime_6B.ItemIndex<6  then
  Timer_Test_6B.Interval :=100
  else
  Timer_Test_6B.Interval :=(ComboBox_IntervalTime_6B.ItemIndex+4)*10;
end;

procedure TfrmUHFReader188demomain.SpeedButton_ReadWrite_6BClick(Sender: TObject);
begin
    if SpeedButton_Write_6B.Down  then
    begin
    if ( Edit_WriteData_6B.Text='' )or (Length(Edit_WriteData_6B.Text)mod 2<>0) then
    begin
    MessageDlg('Please input in bytes in hexadecimal form!'+#13+#10+'for example: 121234', mtInformation, [mbOK], 0);
    SpeedButton_Write_6B.Down:=False;
    Exit;
    end;
    end;
    if SpeedButton_Read_6B.Down or SpeedButton_Write_6B.Down  then
    begin
    if ( Edit_StartAddress_6B.Text='' )or (Edit_Len_6B.Text='') then
    begin
    MessageDlg('Start address or length is empty!Please input!', mtInformation, [mbOK], 0);
    SpeedButton_Read_6B.Down:=False;
    SpeedButton_Write_6B.Down:=False;
    Exit;
    end;
    Timer_6B_ReadWrite.Enabled:=True;
    end
    else
    begin
     if Sender= SpeedButton_Read_6B  then
    StatusBar1.Panels.Items[0].text := FormatDateTime('hh:mm:ss', Now) +  ' "Read"over' ;
    if Sender= SpeedButton_Write_6B  then
    StatusBar1.Panels.Items[0].text := FormatDateTime('hh:mm:ss', Now) +  ' "Write"over' ;
    Timer_6B_ReadWrite.Enabled:=False;
    end;

end;

procedure TfrmUHFReader188demomain.Timer_6B_ReadWriteTimer(Sender: TObject);
var
    i: Integer;
    s2: string;
    CardData: array[0..320] of Char;
    Mem,Num,StartAddress:Byte;
    Writedata:array[0..320] of Char;
    Writedatalen:byte;
    writtenbyte:longint;
begin
  if  fTimer_6B_ReadWrite then    exit;
  fTimer_6B_ReadWrite:=true;
  try

    if SpeedButton_Read_6B.Down  then
    begin
      getCharStr(ComboBox_ID1_6B.text,fOperID_6B);
      StartAddress:=StrToInt('$'+Edit_StartAddress_6B.Text);
      Num:=StrToInt(Edit_Len_6B.Text);
      fCmdRet:=ReadCard_6B(fComAdr,@fOperID_6B,StartAddress,Num,CardData,ferrorcode,frmComPortindex);
      if fCmdRet=0 then
      begin
        for i := 0 to Num - 1 do
        s2 := s2 + IntToHex(ord(CardData[i]), 2);
        Memo_DataShow_6B.Lines.Add(s2);
      end;
      AddCmdLog('ReadCard', 'Read', fCmdRet);
      if not (SpeedButton_Read_6B.Down)  then
      StatusBar1.Panels.Items[0].text := FormatDateTime('hh:mm:ss', Now) +  ' "Read"over' ;
    end;
    
    if SpeedButton_Write_6B.Down  then
    begin
      getCharStr(ComboBox_ID1_6B.text,fOperID_6B);
      StartAddress:=StrToInt('$'+Edit_StartAddress_6B.Text);
      getCharStr(Edit_WriteData_6B.text,Writedata);
      Writedatalen:= Length(Edit_WriteData_6B.text)div 2 ;
      fCmdRet:=WriteCard_6B(fComAdr,@fOperID_6B,StartAddress,Writedata,Writedatalen,writtenbyte,ferrorcode,frmComPortindex);
      AddCmdLog('WriteCard', 'Write', fCmdRet);
      if not (SpeedButton_Write_6B.Down)  then
      StatusBar1.Panels.Items[0].text := FormatDateTime('hh:mm:ss', Now) +  ' "Write"over' ;
    end;
  finally
  fTimer_6B_ReadWrite:=false;
  end;
  if fAppClosed then Close;
end;

procedure TfrmUHFReader188demomain.Action_LockByte_6BExecute(Sender: TObject);
var
   return,Address:Byte;
begin
   getCharStr(ComboBox_ID1_6B.text,fOperID_6B);
   Address:=StrToInt('$'+Edit_StartAddress_6B.Text);
   return:=MessageDlg('permanently Lock the address Confirmed?', mtInformation, [mbOK, mbCancel], 0);   if return = IDCancel then
   Exit;
   fCmdRet:=LockByte_6B(fComAdr,@fOperID_6B,Address,ferrorcode,frmComPortindex);
   AddCmdLog('LockByte_6B', 'Lock', fCmdRet);
end;

procedure TfrmUHFReader188demomain.Action_CheckLock_6BExecute(Sender: TObject);
var
Address,ReLockState:Byte;
begin
   getCharStr(ComboBox_ID1_6B.text,fOperID_6B);
   Address:=StrToInt('$'+Edit_StartAddress_6B.Text);
   fCmdRet:=CheckLock_6B(fComAdr,@fOperID_6B,Address,ReLockState,ferrorcode,frmComPortindex);
   AddCmdLog('CheckLock_6B', 'Check Lock', fCmdRet);
   if fCmdRet=0 then
   begin
     if  ReLockState=$00  then
     StatusBar1.Panels.Items[0].text := FormatDateTime('hh:mm:ss', Now) +  ' "Check Lock"Command Response=0x00' +
               '(The Byte is unlocked)' ;
     if  ReLockState=$01  then
     StatusBar1.Panels.Items[0].text := FormatDateTime('hh:mm:ss', Now) +  ' "Check Lock"Command Response=0x01' +
               '(The Byte is locked)';

   end;
end;

procedure TfrmUHFReader188demomain.Button22Click(Sender: TObject);
begin
 Memo_DataShow_6B.Clear;
end;

procedure TfrmUHFReader188demomain.Action_CheckLock_6BUpdate(Sender: TObject);
var
  CanEnabled_6B:Boolean;
  CanEnabled2_6B:Boolean;
begin
    SpeedButton_Query_6B .Enabled:=ComIsOpen and not (SpeedButton_Read_6B.down)
                                   and not (SpeedButton_Write_6B.down);



    ComboBox_IntervalTime_6B.Enabled:=not (SpeedButton_Query_6B.down) and  ComIsOpen
                   and not (SpeedButton_Read_6B.down)and not (SpeedButton_Write_6B.down);
    CanEnabled_6B:=not (SpeedButton_Query_6B.down) and  ComIsOpen and (ComboBox_ID1_6B.Text<>'')
                   and not (SpeedButton_Read_6B.down)and not (SpeedButton_Write_6B.down);
    CanEnabled2_6B:=not (SpeedButton_Query_6B.down) and  ComIsOpen and (Bycondition_6B.Checked)
                   and not (SpeedButton_Read_6B.down)and not (SpeedButton_Write_6B.down);
    if  Byone_6B.Checked then
    SpeedButton_Query_6B.Caption:='Query by one'
    else
    begin
    SpeedButton_Query_6B.Caption:='Query by Condition';
    end;

    GroupBox14.Enabled:=CanEnabled2_6B;
    Label34.Enabled:=CanEnabled2_6B;
    Label28.Enabled:=CanEnabled2_6B;
    Edit_Query_StartAddress_6B.Enabled:=CanEnabled2_6B;
    Edit_ConditionContent_6B.Enabled:=CanEnabled2_6B;
    Less_6B.Enabled:=CanEnabled2_6B;
    Different_6B.Enabled:=CanEnabled2_6B;
    Same_6B.Enabled:=CanEnabled2_6B;
    Greater_6B.Enabled:=CanEnabled2_6B;

    GroupBox13.Enabled:=not (SpeedButton_Query_6B.down) and  ComIsOpen
                        and (ComboBox_ID1_6B.Text<>'');
    Memo_DataShow_6B.Enabled:=GroupBox13.Enabled;
    Button22.Enabled:=GroupBox13.Enabled;
    SpeedButton_Read_6B.Enabled:=GroupBox13.Enabled and not (SpeedButton_Write_6B.down);
    SpeedButton_Write_6B.Enabled:=GroupBox13.Enabled and not (SpeedButton_Read_6B.down);
    Label29.Enabled:=CanEnabled_6B;
    Label30.Enabled:=CanEnabled_6B;
    Label31.Enabled:=CanEnabled_6B;
    ComboBox_ID1_6B.Enabled:=CanEnabled_6B;
    Edit_WriteData_6B.Enabled:=CanEnabled_6B;
    Edit_StartAddress_6B.Enabled:=CanEnabled_6B;
    Edit_Len_6B.Enabled:=CanEnabled_6B;
    Button14.Enabled:=CanEnabled_6B;
    Button15.Enabled:=CanEnabled_6B;
end;

procedure TfrmUHFReader188demomain.Button6Click(Sender: TObject);
var
  Wg_mode:Byte;
  Wg_Data_Inteval:Byte;
  Wg_Pulse_Width:Byte;
  Wg_Pulse_Inteval:Byte;
begin
  if(RadioButton1.Checked)then
  begin
    if(RadioButton3.Checked) then
    Wg_mode:=2
    else
    Wg_mode:= 0;
  end;
  if(RadioButton2.Checked)then
  begin
    if(RadioButton3.Checked) then
    Wg_mode:=3
    else
    Wg_mode:= 1;
  end;
  Wg_Data_Inteval:=ComboBox1.ItemIndex;
  Wg_Pulse_Width:= ComboBox2.ItemIndex+1;
  Wg_Pulse_Inteval:= ComboBox3.ItemIndex+1 ;
  fCmdRet:=SetWGParameter(fComAdr,Wg_mode,Wg_Data_Inteval,Wg_Pulse_Width,Wg_Pulse_Inteval,frmComPortindex)  ;
  AddCmdLog('Set Parameter', 'SetWGParameter', fCmdRet);
end;

procedure TfrmUHFReader188demomain.Button7Click(Sender: TObject);
var
  Parameter: array[0..6] of Char ;
  Reader_bit0: integer;
  Reader_bit1: integer;
  Reader_bit2: integer;
  Reader_bit3: integer;
  Reader_bit4: integer;
  Reader_bit5: integer;
  Reader_bit6: integer;
  Reader_bit7: integer;
begin
 Parameter[0]:=Char(ComboBox4.ItemIndex);
  if RadioButton5.Checked then
    Reader_bit0 := 0
  else
    Reader_bit0 := 1;
  if RadioButton7.Checked then
    Reader_bit1 := 0
  else
  begin
    Reader_bit1 := 1 ;
  end;

  if RadioButton14.Checked then
    Reader_bit2 := 0
  else
    Reader_bit2 := 1;

  if RadioButton16.Checked then
    Reader_bit3 := 0
  else
    Reader_bit3 := 1;

  Parameter[1]:=Char( Reader_bit0 * 1 +
  Reader_bit1 * 2 +
  Reader_bit2 * 4 +
  Reader_bit3 * 8 +
  Reader_bit4 * 16);
  if(RadioButton9.Checked)then
  Parameter[2]:=Char(0);
  if(RadioButton10.Checked)then
  Parameter[2]:=Char(1);
  if(RadioButton11.Checked)then
  Parameter[2]:=Char(2);
  if(RadioButton12.Checked)then
  Parameter[2]:=Char(3);
  if(RadioButton13.Checked)then
  Parameter[2]:=Char(4);
  if(RadioButton18.Checked)then
  Parameter[2]:=Char(5);
  if(Edit1.Text='')then
  begin
    MessageDlg('Start Address can not be Null', mtInformation, [mbOK], 0);
    Exit;
  end;
  Parameter[3]:=Char(StrToInt('$'+Trim(Edit1.Text))) ;
  Parameter[4]:=Char(ComboBox5.ItemIndex+1);
  Parameter[5]:=Char(ComboBox6.ItemIndex);
  fCmdRet:=SetWorkMode(fComAdr,Parameter,frmComPortindex)  ;
  if(fCmdRet=0)then
  begin
   if(ComboBox4.ItemIndex=1)or (ComboBox4.ItemIndex=2)or (ComboBox4.ItemIndex=3)then
    begin
      if(RadioButton6.Checked)then
      begin
        RadioButton13.Enabled:=False;
      end
      else
      begin

      end;
      Button9.Enabled:=True;
      SpeedButton2.Enabled:=True;
    end;
    if(ComboBox4.ItemIndex=0)then
    begin
      Button9.Enabled:=False ;
      SpeedButton2.Enabled:=False;
    end;
  end;
  AddCmdLog('Set Parameter', 'Set Parameter', fCmdRet);
end;

procedure TfrmUHFReader188demomain.Button8Click(Sender: TObject);
var
   Parameter: array[0..13] of Char;
begin
   fCmdRet:=GetWorkModeParameter(fComAdr,Parameter,frmComPortindex);
   if(fCmdRet=0)then
   begin
     if(Ord(Parameter[0])=0)then
     begin
      RadioButton1.Checked:=True;
      RadioButton4.Checked:=True;
     end;
     if(Ord(Parameter[0])=1)then
     begin
      RadioButton2.Checked:=True;
      RadioButton4.Checked:=True;
     end;
     if(Ord(Parameter[0])=2)then
     begin
      RadioButton1.Checked:=True;
      RadioButton3.Checked:=True;
     end;
     if(Ord(Parameter[0])=3)then
     begin
      RadioButton2.Checked:=True;
      RadioButton3.Checked:=True;
     end;

      ComboBox1.ItemIndex:=Ord(Parameter[1]);
      ComboBox2.ItemIndex:=Ord(Parameter[2])-1;
      ComboBox3.ItemIndex:=Ord(Parameter[3])-1;
      ComboBox4.ItemIndex:=Ord(Parameter[4]);
      if(Ord(Parameter[4])=1)then
      begin
         Button9.Enabled:=True;
         SpeedButton2.Enabled:=True;
         RadioButton5.Enabled :=True;
         RadioButton6.Enabled :=True;
         RadioButton7.Enabled :=True;
         RadioButton8.Enabled :=True;

        if(RadioButton5.Checked)then
        begin
          if(RadioButton7.Checked)then
         begin
          RadioButton16.Enabled :=True;
          RadioButton17.Enabled :=True;
         end
         else
         begin
          RadioButton16.Enabled :=False;
          RadioButton17.Enabled :=False;
         end;
         RadioButton9.Enabled :=True;
         RadioButton10.Enabled :=True;
         RadioButton11.Enabled :=True;
         RadioButton12.Enabled :=True;
         RadioButton18.Enabled :=True;
         if ((Ord(Parameter[5])and $10)=$10) then
         begin
          RadioButton13.Enabled :=False;
         end
         else
         begin
           RadioButton13.Enabled :=True;
         end;
         if(RadioButton13.Checked)then
         begin
           ComboBox6.Enabled:=False;
         end
         else
           ComboBox6.Enabled:=True ;
        end
        else
         ComboBox6.Enabled:=True ;
        RadioButton14.Enabled :=True;
        RadioButton15.Enabled :=True;
        Edit1.Enabled:=True;
        if(RadioButton8.Checked)then
        ComboBox5.Enabled:=True;
      end;
      if(Ord(Parameter[4])=0)then
      begin
        Button9.Enabled:=False;
        SpeedButton2.Enabled:=False;
        RadioButton5.Enabled :=False;
        RadioButton6.Enabled :=False;
        RadioButton7.Enabled :=False;
        RadioButton8.Enabled :=False;
        RadioButton9.Enabled :=False;
        RadioButton10.Enabled :=False;
        RadioButton11.Enabled :=False;
        RadioButton12.Enabled :=False;
        RadioButton13.Enabled :=False;
        RadioButton14.Enabled :=False;
        RadioButton15.Enabled :=False;
        RadioButton16.Enabled :=False;
        RadioButton17.Enabled :=False;
        RadioButton18.Enabled :=False;
        Edit1.Enabled:=False;
        ComboBox5.Enabled:=False;
        ComboBox6.Enabled:=False;
      end;
      if((Ord(Parameter[5])and $01)=0)then
      RadioButton5.Checked:=True
      else
      RadioButton6.Checked:=True;
      if((Ord(Parameter[5])and $02)=0)then
      RadioButton7.Checked:=True
      else
      begin
      if((Ord(Parameter[5])and $10)=0) then
      RadioButton8.Checked:=True
      else

      end;
      if((Ord(Parameter[5])and $04)=0)then
      RadioButton14.Checked:=True
      else
      RadioButton15.Checked:=True;
      if((Ord(Parameter[5])and $08)=0)then
      RadioButton16.Checked:=True
      else
      RadioButton17.Checked:=True;
     if(Ord(Parameter[6])=0)then
     begin
        RadioButton9.Checked:=True;
     end;
     if(Ord(Parameter[6])=1)then
     begin
        RadioButton10.Checked:=True;
     end;
     if(Ord(Parameter[6])=2)then
     begin
        RadioButton11.Checked:=True;
     end;
     if(Ord(Parameter[6])=3)then
     begin
        RadioButton12.Checked:=True;
     end;
     if(Ord(Parameter[6])=4)then
     begin
        RadioButton13.Checked:=True;
     end;
     if(Ord(Parameter[6])=5)then
     begin
        RadioButton18.Checked:=True;
     end;
     Edit1.Text:=IntToHex(Ord(Parameter[7]),2) ;
     ComboBox5.ItemIndex:=Ord(Parameter[8])-1 ;
     ComboBox6.ItemIndex:=Ord(Parameter[9]);
   end;
   AddCmdLog('GetWorkModeParameter', 'GetWorkModeParameter', fCmdRet);
end;

procedure TfrmUHFReader188demomain.RadioButton5Click(Sender: TObject);
begin
 if(RadioButton5.Checked)then
  begin
   if(ComboBox4.ItemIndex=1)or(ComboBox4.ItemIndex=2)or(ComboBox4.ItemIndex=3)then
   begin
    RadioButton9.Enabled:=True;
    RadioButton10.Enabled:=True;
    RadioButton11.Enabled:=True;
    RadioButton12.Enabled:=True;
    RadioButton18.Enabled:=True;
    if(RadioButton16.Checked)then
      Label40.Caption:='First Word Addr(Hex):'
    else
      Label40.Caption:='First Byte Addr(Hex):';

      RadioButton13.Enabled:=True;
    if(RadioButton7.Checked)then
    begin
      RadioButton16.Enabled:=True;
      RadioButton17.Enabled:=True;
      if(RadioButton13.Checked)then
      begin
        ComboBox6.Enabled:=False;
      end
      else
        ComboBox6.Enabled:=True;
    end
    else
    begin
      RadioButton16.Enabled:=False;
      RadioButton17.Enabled:=False;
      if(RadioButton13.Checked)then
      begin
         ComboBox6.Enabled:=False;
      end
      else
        ComboBox6.Enabled:=True;

      Label40.Caption:='First Word Addr(Hex):';
    end;

   end;
  //ComboBox4.Enabled:=True;
  end
 else
  begin
    RadioButton9.Enabled:=False;
    RadioButton10.Enabled:=False;
    RadioButton11.Enabled:=False;
    RadioButton12.Enabled:=False;
    RadioButton13.Enabled:=False;
    RadioButton18.Enabled:=False;
    RadioButton16.Enabled:=False;
    RadioButton17.Enabled:=False;
    Label40.Caption:='First Byte Addr(Hex):';
    ComboBox6.Enabled:=True;
  end;
end;

procedure TfrmUHFReader188demomain.Timer1Timer(Sender: TObject);
var
  ScanModeData:array[0..40960]of Char;
  ValidDatalength:LongInt;
  temp,temp1:string ;
  temps:string;
  i:Integer;
begin
  if(ISscanstring)then
  Exit;
  ISscanstring:=True;
  fCmdRet:=ReadActiveModeData(ScanModeData, ValidDatalength,frmComPortindex);
  if(fCmdRet=0)then
  begin
  temp:=getStr(ScanModeData,ValidDatalength);
  temps:=getHexStr(temp);
  temp1:='';
  for i:=0 to  ValidDatalength-1 do
   temp1:=temp1+copy(temps,i*2+1,2)+' ';
    if(Trim(temp1)<>'')then
    Memo1.Lines.Add(temp1);
  end;
  ISscanstring:=False;
    if fAppClosed then Close;
end;
procedure TfrmUHFReader188demomain.SpeedButton2Click(Sender: TObject);
begin
 if not (SpeedButton2.Down) then
  begin
    Timer1.Enabled:=False;
    SpeedButton2.Caption:='Start';
  end
  else
  begin
    Memo1.Lines.Clear;
    Timer1.Enabled:=True;
    SpeedButton2.Caption:='Stop';

  end;
end;

procedure TfrmUHFReader188demomain.Button9Click(Sender: TObject);
begin
Memo1.Lines.Clear;
end;

procedure TfrmUHFReader188demomain.RadioButton7Click(Sender: TObject);
begin
   if(RadioButton5.Checked)then
  begin
    RadioButton16.Enabled:=True;
    RadioButton17.Enabled:=True;
    RadioButton13.Enabled:=True;
    if(RadioButton16.Checked)then
      Label40.Caption:='First Word Addr(Hex):'
    else
      Label40.Caption:='First Byte Addr(Hex):';
    Label41.Caption:='Read Word Num:';
  end;
   ComboBox5.Enabled:=False;
end;

procedure TfrmUHFReader188demomain.RadioButton8Click(Sender: TObject);
var
  i:Integer;
begin
 if(ComboBox4.ItemIndex=1)or(ComboBox4.ItemIndex=2)or(ComboBox4.ItemIndex=3)then
  begin

      if(RadioButton8.Checked)then
      ComboBox5.Enabled:=True;
       ComboBox5.Items.Clear;

    for i:= 1 to 32 do
    ComboBox5.Items.Add(IntToStr(i));
    ComboBox5.ItemIndex :=0;
    Label41.Caption:='Read Word Number:';
    Label40.Caption:='First Word Addr(Hex):';
    if(RadioButton5.Checked)then
    begin
    RadioButton16.Enabled:=False;
    RadioButton17.Enabled:=False;
    RadioButton13.Enabled:=True;
    end
    else
    begin
      Label40.Caption:='First Byte Addr(Hex):';
      RadioButton13.Enabled:=False;
    end;
  end;
end;

procedure TfrmUHFReader188demomain.ComboBox4Change(Sender: TObject);
var
  i:Integer;
begin
if(ComboBox4.ItemIndex=0)then
 begin
   RadioButton5.Enabled :=False;
   RadioButton6.Enabled :=False;
   RadioButton7.Enabled :=False;
   RadioButton8.Enabled :=False;
   RadioButton9.Enabled :=False;
   RadioButton10.Enabled :=False;
   RadioButton11.Enabled :=False;
   RadioButton12.Enabled :=False;
   RadioButton13.Enabled :=False;
   RadioButton14.Enabled :=False;
   RadioButton15.Enabled :=False;
   RadioButton16.Enabled :=False;
   RadioButton17.Enabled :=False;
   RadioButton18.Enabled :=False;
   Edit1.Enabled:=False;
   ComboBox5.Enabled:=False;
   ComboBox6.Enabled:=False;
 end;
 if(ComboBox4.ItemIndex=1) or (ComboBox4.ItemIndex=2) or (ComboBox4.ItemIndex=3)then
 begin
   RadioButton5.Enabled :=True;
   RadioButton6.Enabled :=True;
   RadioButton7.Enabled :=True;
   RadioButton8.Enabled :=True;
   ComboBox5.Items.Clear;

     for i:= 1 to 32 do
     ComboBox5.Items.Add(IntToStr(i));
     ComboBox5.ItemIndex:=0;
     Label41.Caption:='Read Word Number:';
   if(RadioButton7.Checked)then
     begin
      RadioButton16.Enabled :=True;
      RadioButton17.Enabled :=True;
     end
   else
   begin
     RadioButton16.Enabled :=False;
     RadioButton17.Enabled :=False;
   end;
   if(RadioButton5.Checked)then
    begin
     RadioButton9.Enabled :=True;
     RadioButton10.Enabled :=True;
     RadioButton11.Enabled :=True;
     RadioButton12.Enabled :=True;
     RadioButton18.Enabled :=True;
     RadioButton13.Enabled :=True;
     if(RadioButton13.Checked)then
     begin
       ComboBox6.Enabled:=False;
     end
     else
       ComboBox6.Enabled:=True ;
    end
   else
    ComboBox6.Enabled:=True ;
   RadioButton14.Enabled :=True;
   RadioButton15.Enabled :=True;
   Edit1.Enabled:=True;
   if (RadioButton7.Checked)then
    ComboBox5.Enabled:=false
   else
    ComboBox5.Enabled:=True;
 end;
end;

procedure TfrmUHFReader188demomain.RadioButton_band2Click(Sender: TObject);
var
  i:Integer;
begin
  ComboBox_dminfre.Items.Clear;
  ComboBox_dmaxfre.Items.Clear;
  for i:=0 to 19 do
  begin
    ComboBox_dminfre.Items.Add(floattostr(920.125+i*0.25)+' MHz');
    ComboBox_dmaxfre.Items.Add( floattostr(920.125+i*0.25)+' MHz');
  end;
  ComboBox_dminfre.ItemIndex := 0;
  ComboBox_dmaxfre.ItemIndex := 19;
end;

procedure TfrmUHFReader188demomain.RadioButton_band3Click(Sender: TObject);
var
  i:Integer;
begin
  ComboBox_dminfre.Items.Clear;
  ComboBox_dmaxfre.Items.Clear;
  for i:=0 to 49 do
  begin
    ComboBox_dminfre.Items.Add(floattostr(902.75+i*0.5)+' MHz');
    ComboBox_dmaxfre.Items.Add( floattostr(902.75+i*0.5)+' MHz');
  end;
  ComboBox_dminfre.ItemIndex := 0;
  ComboBox_dmaxfre.ItemIndex := 49;
end;

procedure TfrmUHFReader188demomain.RadioButton_band4Click(Sender: TObject);
var
  i:Integer;
begin
  ComboBox_dminfre.Items.Clear;
  ComboBox_dmaxfre.Items.Clear;
  for i:=0 to 31 do
  begin
    ComboBox_dminfre.Items.Add(floattostr(917.1+i*0.2)+' MHz');
    ComboBox_dmaxfre.Items.Add( floattostr(917.1+i*0.2)+' MHz');
  end;
  ComboBox_dminfre.ItemIndex:=0;
  ComboBox_dmaxfre.ItemIndex:=31;
end;

procedure TfrmUHFReader188demomain.RadioButton16Click(Sender: TObject);
begin
Label40.Caption:='First Word Addr(Hex):';
end;

procedure TfrmUHFReader188demomain.RadioButton17Click(Sender: TObject);
begin
Label40.Caption:='First Byte Addr(Hex):';
end;

procedure TfrmUHFReader188demomain.RadioButton9Click(Sender: TObject);
begin
ComboBox6.Enabled:=True;
end;

procedure TfrmUHFReader188demomain.RadioButton10Click(Sender: TObject);
begin
ComboBox6.Enabled:=True;
end;

procedure TfrmUHFReader188demomain.RadioButton11Click(Sender: TObject);
begin
ComboBox6.Enabled:=True;
end;

procedure TfrmUHFReader188demomain.RadioButton12Click(Sender: TObject);
begin
ComboBox6.Enabled:=True;
end;

procedure TfrmUHFReader188demomain.RadioButton13Click(Sender: TObject);
begin
ComboBox6.Enabled:=False;
end;

procedure TfrmUHFReader188demomain.RadioButton18Click(Sender: TObject);
begin
  ComboBox6.Enabled:=True;
end;

procedure TfrmUHFReader188demomain.RadioButton19Click(Sender: TObject);
begin
  ComboBox6.Enabled:=False;
end;

procedure TfrmUHFReader188demomain.ComboBox_COMChange(Sender: TObject);
begin
ComboBox_baud2.Items.Clear;
if(ComboBox_COM.ItemIndex=0)then
begin
  ComboBox_baud2.Items.Add('9600bps');
  ComboBox_baud2.Items.Add('19200bps');
  ComboBox_baud2.Items.Add('38400bps');
  ComboBox_baud2.Items.Add('57600bps');
  ComboBox_baud2.Items.Add('115200bps');
  ComboBox_baud2.ItemIndex:=3;
end
else
begin
  ComboBox_baud2.Items.Add('Auto');
  ComboBox_baud2.ItemIndex:=0;
end;
end;

procedure TfrmUHFReader188demomain.Button_writeblockClick(Sender: TObject);
var
    Mem,Num,WordPtr:Byte;
    Writedata:array[0..320] of Char;
    Writedatalen:byte;
    EPClength:byte;
    i: Integer;
    s,s2: string;
    CardData: array[0..320] of Char;
    WrittenDataNum:LongInt;
begin
    if(Edit2.Text='')or(Edit3.Text='')then
    Exit ;
    if CheckBox1.Checked then
    maskFlag:=1
    else
    maskFlag:=0;
    maskadr:= StrToInt('$'+Edit2.Text);
    maskLen:= StrToInt('$'+Edit3.Text);
    if Length(Edit_AccessCode2.Text)<8 then
    begin
      MessageDlg('Access Password Less Than 8 digit!Please input again!', mtInformation, [mbOK], 0);
      Exit;
    end;
    if (Edit_WordPtr.Text='')or (Edit_Len.Text='')then
    begin
      MessageDlg('Start address or length is empty!Please input!', mtInformation, [mbOK], 0);
      Exit;
    end;
    getCharStr(ComboBox_EPC2.text,fOperEPC);
    getCharStr(Edit_AccessCode2.text,fPassword);
    EPClength:=Length(ComboBox_EPC2.text) div 2;
    WordPtr:=StrToInt('$'+Edit_WordPtr.Text);
    Num:=StrToInt(Edit_Len.Text);
    if  C_Reserve.Checked then
      Mem:=0
    else if  C_EPC.Checked then
      Mem:=1
    else if  C_TID.Checked then
      Mem:=2
    else if  C_User.Checked then
      Mem:=3;
      if ( Edit_WriteData.Text='' )or (Length(Edit_WriteData.Text)mod 4<>0) then
      begin
      MessageDlg('Please input Data in words in hexadecimal form!'+#13+#10+'For example: 123412345678', mtInformation, [mbOK], 0);
      Exit;
      end;
      Writedatalen:= Length(Edit_WriteData.text)div 2 ;
      getCharStr(Edit_WriteData.text,Writedata);
       if(CheckBox2.Checked)and(C_EPC.Checked)then
      begin
       WordPtr:=1;
       Writedatalen:= Length(Edit_WriteData.text)div 2 +2;
       getCharStr(edit_pc.Text+Edit_WriteData.text,Writedata);
      end;
      fCmdRet:=WriteBlock_G2(fComAdr,@fOperEPC,Mem,WordPtr,Writedatalen,@Writedata,@fPassword,maskadr,maskLen,maskFlag,WrittenDataNum,EPClength,ferrorcode,frmComPortindex);
      AddCmdLog('WriteBlock','Write Block', fCmdRet,ferrorcode);
      if fCmdRet=0 then
      begin
      StatusBar1.Panels.Items[0].text := FormatDateTime('hh:mm:ss', Now) +  ' WriteBlockCommand Response=0x00' +
                  '(completely write Block successfully)';
      end;

end;

procedure TfrmUHFReader188demomain.CheckBox_TIDClick(Sender: TObject);
begin
if(CheckBox_TID.Checked)then
  begin
  GroupBox31.Enabled:=True;
  Edit4.Enabled:=True;
  Edit5.Enabled:=True;
  end
 else
  begin
  GroupBox31.Enabled:=False;
  Edit4.Enabled:=False;
  Edit5.Enabled:=False;
  end;
end;

procedure TfrmUHFReader188demomain.CheckBox2Click(Sender: TObject);
var
  m,n:Integer;
begin
 if(CheckBox2.Checked)then
  begin
    if(C_EPC.Checked)then
    begin
    Edit_WordPtr.Text:='02';
    Edit_WordPtr.ReadOnly:=True;
    end;
    n:= Length(Trim(Edit_WriteData.Text));
    if(CheckBox2.Checked)and(n mod 4=0)and(C_EPC.Checked)then
    begin
      m:=n div 4;
      m:=(m and $3F) shl 3;
      Edit_PC.Text:=IntToHex(m,2)+'00';
    end;

  end
  else
  begin
    Edit_WordPtr.ReadOnly:=False;;
  end;
end;

procedure TfrmUHFReader188demomain.Edit_LenKeyPress(Sender: TObject;
  var Key: Char);
  var L:Boolean;
begin
    L:=(key<#8)or(key>#8)and(key<#48)or(key>#57);
    if l then key:=#0;
    if ( (key>#96)and(key<#103)) then  key:=  char(Ord(key)-32);
end;

procedure TfrmUHFReader188demomain.RadioButton_band5Click(Sender: TObject);
var
  i:Integer;
begin
  ComboBox_dminfre.Items.Clear;
  ComboBox_dmaxfre.Items.Clear;
  for i:=0 to 14 do
  begin
    ComboBox_dminfre.Items.Add(floattostr(865.1+i*0.2)+' MHz');
    ComboBox_dmaxfre.Items.Add( floattostr(865.1+i*0.2)+' MHz');
  end;
  ComboBox_dminfre.ItemIndex:=0;
  ComboBox_dmaxfre.ItemIndex:=14;
end;

procedure TfrmUHFReader188demomain.Edit_WriteDataChange(Sender: TObject);
var
  m,n:Integer;
begin    //
  n:= Length(Trim(Edit_WriteData.Text));
    if(CheckBox2.Checked)and(n mod 4=0)and(C_EPC.Checked)then
    begin
      m:=n div 4;
      m:=(m and $3F) shl 3;
      Edit_PC.Text:=IntToHex(m,2)+'00';
    end;
end;

procedure TfrmUHFReader188demomain.C_ReserveClick(Sender: TObject);
begin
Edit_WordPtr.ReadOnly:=False;
end;

procedure TfrmUHFReader188demomain.C_TIDClick(Sender: TObject);
begin
Edit_WordPtr.ReadOnly:=False;
end;

procedure TfrmUHFReader188demomain.C_UserClick(Sender: TObject);
begin
Edit_WordPtr.ReadOnly:=False;
end;

procedure TfrmUHFReader188demomain.C_EPCClick(Sender: TObject);
begin
  if CheckBox2.Checked then
  begin
    Edit_WordPtr.ReadOnly:=True;
    Edit_WordPtr.Text:='02';
  end
  else
  begin
   Edit_WordPtr.ReadOnly:=False;
  end;
end;

procedure TfrmUHFReader188demomain.Button_relayClick(Sender: TObject);
var
  RelayStatus:byte;
begin
   RelayStatus:=0;
  if(ComboBox9.ItemIndex=0)then
  RelayStatus:=RelayStatus or 0
  else
  RelayStatus:=RelayStatus or 1;
  if(ComboBox10.ItemIndex=0)then
  RelayStatus:=RelayStatus or 0
  else
  RelayStatus:=RelayStatus or 2;
  fCmdRet:=SetRelay(fComAdr,RelayStatus,frmComPortindex);
  AddCmdLog('SetRelay', 'Set', fCmdRet);
end;

procedure TfrmUHFReader188demomain.Button11Click(Sender: TObject);
var
  comd:string;
  aDateTime: TDateTime;
  hexstr,str,str1:string;
  i,t,dwNo,bOpt:integer;
  ecode:string;
  aListItem:TListItem;
begin
  ListView1.Items.Clear;
  try
  IdUDPServer2.DefaultPort:=0;
  IdUDPServer2.Active:=True;
  except
   MessageDlg('Service port conflict!', mtInformation, [mbOK], 0);
  end;
  comd:= 'X';
  IdUDPServer2.Bindings[0].IP:='255.255.255.255';
  IdUDPServer2.Bindings[0].Port:=65535;
  bOpt:=1;
  IdUDPServer2.Bindings[0].SetSockOpt(65535,$20,@bOpt, SizeOf(bOpt));
  IdUDPServer2.Bindings[0].SendTo(IdUDPServer2.Bindings[0].IP,IdUDPServer2.Bindings[0].Port,comd[1],Length(comd));
end;

procedure TfrmUHFReader188demomain.Button12Click(Sender: TObject);
begin
 locateForm.Show ;
end;

procedure TfrmUHFReader188demomain.Button17Click(Sender: TObject);
begin
 ChangeIPdlg.Show;
end;

procedure TfrmUHFReader188demomain.Button13Click(Sender: TObject);
var
  select_index:Integer;
  comd:string;
  aDateTime: TDateTime;
  hexstr,str,str1:string;
  i,t,dwNo,bOpt:integer;
  ecode:string;
  aListItem:TListItem;
begin
 if ListView1.Selected = nil then
  begin
    MessageDlg('No select device!', mtWarning, [mbOK], 0);
    exit;
  end;
  if ListView1.Selected.SubItems[0]<>''then
  begin
    IP:=ListView1.Selected.SubItems[1];
    mac:= ListView1.Selected.SubItems[0];
    select_index:= ListView1.Selected.Index;
  end
  else
  begin
    Exit;
  end;
  try
    IdUDPServer1.DefaultPort:=0;
    IdUDPServer1.Active:=True;
  except
    MessageDlg('Service port conflict!', mtInformation, [mbOK], 0);
  end;
 // IdUDPServer1.Bindings[0].IP:='255.255.255.255';
  IdUDPServer1.Bindings[0].IP:=IP;
  IdUDPServer1.Bindings[0].Port:=65535;

  i:=0;
  while(i<3)do
  begin
   comd:='X';
   IdUDPServer1.Bindings[0].SendTo(IdUDPServer1.Bindings[0].IP,IdUDPServer1.Bindings[0].Port,comd[1],Length(comd));
   fRecvUDPstring:='';
   aDateTime := Now;
    while (Now < IncMilliSecond(aDateTime, 1000 )) do //ѯʱû
    begin
        Application.ProcessMessages;
        if fRecvUDPstring <> '' then
        begin
           ecode:=Copy(fRecvUDPstring,1,1);
           if(ecode='A')then
           begin
              mac:=Copy(fRecvUDPstring,2,Pos('/',fRecvUDPstring)-2);
              IP:= RemostIP;
              t :=Pos('*',fRecvUDPstring)+8;
              str1:=Copy(fRecvUDPstring,t,Length(fRecvUDPstring)-t+1)   ;
              t:=Pos('/',str1);
              usename:=Copy(str1,1,t-1);
              dsname:=Copy(str1,t+1,Length(str1)-t+1);
              i:=3;
              Break;
           end;
        end;
    end;
    i:=i+1;
  end;
  i:=0;
  bOpt:=1;
  IdUDPServer1.Bindings[0].SetSockOpt(65535,$20,@bOpt, SizeOf(bOpt));
  while(i<3)do
  begin
   comd:='W';
   comd:=comd+mac;
   IdUDPServer1.Bindings[0].SendTo( IdUDPServer1.Bindings[0].IP,IdUDPServer1.Bindings[0].Port,comd[1],Length(comd));
   fRecvUDPstring:='';
   Sleep(100);
   Application.ProcessMessages;
   aDateTime := Now;
    while (Now < IncMilliSecond(aDateTime, 1000 )) do //ѯʱû
    begin
      Application.ProcessMessages;
      if fRecvUDPstring <> '' then
      begin
        ecode:=Copy(fRecvUDPstring,1,1);
        if(ecode='A')then
        begin
         i:=3;
         Break;
        end;
      end;
    end;
    i:=i+1;
  end;
  i:=0;
   while(i<3)do
  begin
   comd:='L';
   IdUDPServer1.Bindings[0].SendTo( IdUDPServer1.Bindings[0].IP,IdUDPServer1.Bindings[0].Port,comd[1],Length(comd));
   fRecvUDPstring:='';
   Sleep(50);
   Application.ProcessMessages;
   aDateTime := Now;
    while (Now < IncMilliSecond(aDateTime, 1000 )) do //ѯʱû
    begin
      Application.ProcessMessages;
      if fRecvUDPstring <> '' then
      begin
        ecode:=Copy(fRecvUDPstring,1,1);
        if(ecode='A')then
        begin
         i:=3;
         Break;
        end;
      end;
    end;
    i:=i+1;
  end;
  i:=0;
   while(i<3)do
  begin
    comd:='GON|1';
    IdUDPServer1.Bindings[0].SendTo( IdUDPServer1.Bindings[0].IP,IdUDPServer1.Bindings[0].Port,comd[1],Length(comd));
    fRecvUDPstring:='';
    Sleep(10);
    aDateTime := Now;
    while (Now < IncMilliSecond(aDateTime, 1000 )) do //ѯʱû
    begin
      Application.ProcessMessages;
      if fRecvUDPstring <> '' then
      begin
        ecode:=Copy(fRecvUDPstring,1,1);
        if(ecode='A')then
        begin
         t:=Pos('|',fRecvUDPstring);
         if(Copy(fRecvUDPstring,t+1,1)='1')then
         usename:=Copy(fRecvUDPstring,2,t-2);
         i:=3;
         Break;
        end;
      end;
    end;
    i:=i+1;
  end;
  i:=0;
  while(i<3)do
  begin
   comd:='GDN|2';
    IdUDPServer1.Bindings[0].SendTo( IdUDPServer1.Bindings[0].IP,IdUDPServer1.Bindings[0].Port,comd[1],Length(comd));
   fRecvUDPstring:='';
   Sleep(50);
   aDateTime := Now;
    while (Now < IncMilliSecond(aDateTime, 1000 )) do //ѯʱû
    begin
        Application.ProcessMessages;
        if fRecvUDPstring <> '' then
        begin
           ecode:=Copy(fRecvUDPstring,1,1);
           if(ecode='A')then
           begin
             t:=Pos('|',fRecvUDPstring);
             if(Copy(fRecvUDPstring,t+1,1)='2')then
             dsname:=Copy(fRecvUDPstring,2,t-2);
             i:=3;
             Break;
           end;

        end;
    end;
    i:=i+1;
  end;

  i:=0;
  while(i<3)do
  begin
   comd:='GFE|3';
   IdUDPServer1.Bindings[0].SendTo( IdUDPServer1.Bindings[0].IP,IdUDPServer1.Bindings[0].Port,comd[1],Length(comd));
   fRecvUDPstring:='';
   Sleep(50);
   aDateTime := Now;
    while (Now < IncMilliSecond(aDateTime, 1000 )) do //ѯʱû
    begin
      Application.ProcessMessages;
      if fRecvUDPstring <> '' then
      begin
         ecode:=Copy(fRecvUDPstring,1,1);
         if(ecode='A')then
         begin
           t:=Pos('|',fRecvUDPstring);
           if(Copy(fRecvUDPstring,t+1,1)='3')then
           mac:=Copy(fRecvUDPstring,2,t-2);
           i:=3;
           Break;
         end;
      end;
    end;
    i:=i+1;
  end;

  i:=0;
  while(i<3)do
  begin
   comd:='GIP|4';
    IdUDPServer1.Bindings[0].SendTo( IdUDPServer1.Bindings[0].IP,IdUDPServer1.Bindings[0].Port,comd[1],Length(comd));
   fRecvUDPstring:='';
   Sleep(50);
   aDateTime := Now;
    while (Now < IncMilliSecond(aDateTime, 1000 )) do //ѯʱû
    begin
        Application.ProcessMessages;
        if fRecvUDPstring <> '' then
        begin
           ecode:=Copy(fRecvUDPstring,1,1);
           if(ecode='A')then
           begin
            t:=Pos('|',fRecvUDPstring);
            if(Copy(fRecvUDPstring,t+1,1)='4')then
            IP:=Copy(fRecvUDPstring,2,t-2);
            i:=3;
            Break;
           end;

        end;
    end;
    i:=i+1;
  end;
  i:=0;
  while(i<3)do
  begin
   comd:='GPN|5';
    IdUDPServer1.Bindings[0].SendTo( IdUDPServer1.Bindings[0].IP,IdUDPServer1.Bindings[0].Port,comd[1],Length(comd));
   fRecvUDPstring:='';
   Application.ProcessMessages;
   aDateTime := Now;
    while (Now < IncMilliSecond(aDateTime, 1000 )) do //ѯʱû
    begin
        Application.ProcessMessages;
        if fRecvUDPstring <> '' then
        begin
           ecode:=Copy(fRecvUDPstring,1,1);
           if(ecode='A')then
           begin
            t:=Pos('|',fRecvUDPstring);
            if(Copy(fRecvUDPstring,t+1,1)='5')then
            portnum:=Copy(fRecvUDPstring,2,t-2);
            i:=3;
            Break;
           end;

        end;
    end;
    i:=i+1;
  end;

   i:=0;
  while(i<3)do
  begin
   comd:='GTP|6';
    IdUDPServer1.Bindings[0].SendTo( IdUDPServer1.Bindings[0].IP,IdUDPServer1.Bindings[0].Port,comd[1],Length(comd));
   fRecvUDPstring:='';
   Application.ProcessMessages;
   aDateTime := Now;
    while (Now < IncMilliSecond(aDateTime, 1000 )) do //ѯʱû
    begin
        Application.ProcessMessages;
        if fRecvUDPstring <> '' then
        begin
           ecode:=Copy(fRecvUDPstring,1,1);
           if(ecode='A')then
           begin
            t:=Pos('|',fRecvUDPstring);
            if(Copy(fRecvUDPstring,t+1,1)='6')then
            tup:=Copy(fRecvUDPstring,2,t-2);
            i:=3;
            Break;
           end;

        end;
    end;
    i:=i+1;
  end;

  i:=0;
  while(i<3)do
  begin
   comd:='GRM|7';
   IdUDPServer1.Bindings[0].SendTo( IdUDPServer1.Bindings[0].IP,IdUDPServer1.Bindings[0].Port,comd[1],Length(comd));
   fRecvUDPstring:='';
   Application.ProcessMessages;
   aDateTime := Now;
    while (Now < IncMilliSecond(aDateTime, 1000 )) do //ѯʱû
    begin
        Application.ProcessMessages;
        if fRecvUDPstring <> '' then
        begin
           ecode:=Copy(fRecvUDPstring,1,1);
           if(ecode='A')then
           begin
            t:=Pos('|',fRecvUDPstring);
            if(Copy(fRecvUDPstring,t+1,1)='7')then
            rm:=Copy(fRecvUDPstring,2,t-2);
            i:=3;
            Break;
           end;

        end;
    end;
    i:=i+1;
  end;

  i:=0;
  while(i<3)do
  begin
   comd:='GCM|8';
    IdUDPServer1.Bindings[0].SendTo( IdUDPServer1.Bindings[0].IP,IdUDPServer1.Bindings[0].Port,comd[1],Length(comd));
   fRecvUDPstring:='';
   Application.ProcessMessages;
   aDateTime := Now;
    while (Now < IncMilliSecond(aDateTime, 1000 )) do //ѯʱû
    begin
        Application.ProcessMessages;
        if fRecvUDPstring <> '' then
        begin
           ecode:=Copy(fRecvUDPstring,1,1);
           if(ecode='A')then
           begin
            t:=Pos('|',fRecvUDPstring);
            if(Copy(fRecvUDPstring,t+1,1)='8')then
            cm:=Copy(fRecvUDPstring,2,t-2);
            i:=3;
            Break;
           end;

        end;
    end;
    i:=i+1;
  end;

   i:=0;
  while(i<3)do
  begin
   comd:='GCT|9';
    IdUDPServer1.Bindings[0].SendTo( IdUDPServer1.Bindings[0].IP,IdUDPServer1.Bindings[0].Port,comd[1],Length(comd));
   fRecvUDPstring:='';
   Application.ProcessMessages;
   aDateTime := Now;
    while (Now < IncMilliSecond(aDateTime, 1000 )) do //ѯʱû
    begin
        Application.ProcessMessages;
        if fRecvUDPstring <> '' then
        begin
           ecode:=Copy(fRecvUDPstring,1,1);
           if(ecode='A')then
           begin
            t:=Pos('|',fRecvUDPstring);
            if(Copy(fRecvUDPstring,t+1,1)='9')then
            ct:=Copy(fRecvUDPstring,2,t-2);
            i:=3;
            Break;
           end;

        end;
    end;
    i:=i+1;
  end;

  i:=0;
  while(i<3)do
  begin
   comd:='GFC|10';
    IdUDPServer1.Bindings[0].SendTo( IdUDPServer1.Bindings[0].IP,IdUDPServer1.Bindings[0].Port,comd[1],Length(comd));
   fRecvUDPstring:='';
   Application.ProcessMessages;
   aDateTime := Now;
    while (Now < IncMilliSecond(aDateTime, 1000 )) do //ѯʱû
    begin
        Application.ProcessMessages;
        if fRecvUDPstring <> '' then
        begin
           ecode:=Copy(fRecvUDPstring,1,1);
           if(ecode='A')then
           begin
            t:=Pos('|',fRecvUDPstring);
            if(Copy(fRecvUDPstring,t+1,2)='10')then
            fc:=Copy(fRecvUDPstring,2,t-2);
            i:=3;
            Break;
           end;

        end;
    end;
    i:=i+1;
  end;

   i:=0;
  while(i<3)do
  begin
   comd:='GDT|11';
    IdUDPServer1.Bindings[0].SendTo( IdUDPServer1.Bindings[0].IP,IdUDPServer1.Bindings[0].Port,comd[1],Length(comd));
   fRecvUDPstring:='';
   Application.ProcessMessages;
   aDateTime := Now;
    while (Now < IncMilliSecond(aDateTime, 1000 )) do //ѯʱû
    begin
        Application.ProcessMessages;
        if fRecvUDPstring <> '' then
        begin
           ecode:=Copy(fRecvUDPstring,1,1);
           if(ecode='A')then
           begin
            t:=Pos('|',fRecvUDPstring);
            if(Copy(fRecvUDPstring,t+1,2)='11')then
            dt:=Copy(fRecvUDPstring,2,t-2);
            i:=3;
            Break;
           end;

        end;
    end;
    i:=i+1;
  end;

  i:=0;
  while(i<3)do
  begin
   comd:='GBR|12';
    IdUDPServer1.Bindings[0].SendTo( IdUDPServer1.Bindings[0].IP,IdUDPServer1.Bindings[0].Port,comd[1],Length(comd));
   fRecvUDPstring:='';
   Application.ProcessMessages;
   aDateTime := Now;
    while (Now < IncMilliSecond(aDateTime, 1000 )) do //ѯʱû
    begin
        Application.ProcessMessages;
        if fRecvUDPstring <> '' then
        begin
           ecode:=Copy(fRecvUDPstring,1,1);
           if(ecode='A')then
           begin
            t:=Pos('|',fRecvUDPstring);
            if(Copy(fRecvUDPstring,t+1,2)='12')then
            br:=Copy(fRecvUDPstring,2,t-2);
            i:=3;
            Break;
           end;

        end;
    end;
    i:=i+1;
  end;

  i:=0;
  while(i<3)do
  begin
   comd:='GPR|13';
    IdUDPServer1.Bindings[0].SendTo( IdUDPServer1.Bindings[0].IP,IdUDPServer1.Bindings[0].Port,comd[1],Length(comd));
   fRecvUDPstring:='';
   Application.ProcessMessages;
   aDateTime := Now;
    while (Now < IncMilliSecond(aDateTime, 1000 )) do //ѯʱû
    begin
        Application.ProcessMessages;
        if fRecvUDPstring <> '' then
        begin
           ecode:=Copy(fRecvUDPstring,1,1);
           if(ecode='A')then
           begin
            t:=Pos('|',fRecvUDPstring);
            if(Copy(fRecvUDPstring,t+1,2)='13')then
            pr:=Copy(fRecvUDPstring,2,t-2);
            i:=3;
            Break;
           end;

        end;
    end;
    i:=i+1;
  end;

   i:=0;
  while(i<3)do
  begin
   comd:='GBB|14';
    IdUDPServer1.Bindings[0].SendTo( IdUDPServer1.Bindings[0].IP,IdUDPServer1.Bindings[0].Port,comd[1],Length(comd));
   fRecvUDPstring:='';
   Application.ProcessMessages;
   aDateTime := Now;
    while (Now < IncMilliSecond(aDateTime, 1000 )) do //ѯʱû
    begin
        Application.ProcessMessages;
        if fRecvUDPstring <> '' then
        begin
           ecode:=Copy(fRecvUDPstring,1,1);
           if(ecode='A')then
           begin
            t:=Pos('|',fRecvUDPstring);
            if(Copy(fRecvUDPstring,t+1,2)='14')then
            bb:=Copy(fRecvUDPstring,2,t-2);
            i:=3;
            Break;
           end;

        end;
    end;
    i:=i+1;
  end;

  i:=0;
  while(i<3)do
  begin
   comd:='GRC|15';
    IdUDPServer1.Bindings[0].SendTo( IdUDPServer1.Bindings[0].IP,IdUDPServer1.Bindings[0].Port,comd[1],Length(comd));
   fRecvUDPstring:='';
   Application.ProcessMessages;
   aDateTime := Now;
    while (Now < IncMilliSecond(aDateTime, 1000 )) do //ѯʱû
    begin
        Application.ProcessMessages;
        if fRecvUDPstring <> '' then
        begin
           ecode:=Copy(fRecvUDPstring,1,1);
           if(ecode='A')then
           begin
            t:=Pos('|',fRecvUDPstring);
            if(Copy(fRecvUDPstring,t+1,2)='15')then
            rc:=Copy(fRecvUDPstring,2,t-2);
            i:=3;
            Break;
           end;

        end;
    end;
    i:=i+1;
  end;

  i:=0;
  while(i<3)do
  begin
   comd:='GML|16';
    IdUDPServer1.Bindings[0].SendTo( IdUDPServer1.Bindings[0].IP,IdUDPServer1.Bindings[0].Port,comd[1],Length(comd));
   fRecvUDPstring:='';
   Application.ProcessMessages;
   aDateTime := Now;
    while (Now < IncMilliSecond(aDateTime, 1000 )) do //ѯʱû
    begin
        Application.ProcessMessages;
        if fRecvUDPstring <> '' then
        begin
           ecode:=Copy(fRecvUDPstring,1,1);
           if(ecode='A')then
           begin
            t:=Pos('|',fRecvUDPstring);
            if(Copy(fRecvUDPstring,t+1,2)='16')then
            ml:=Copy(fRecvUDPstring,2,t-2);
            i:=3;
            Break;
           end;
        end;
    end;
    i:=i+1;
  end;

  i:=0;
  while(i<3)do
  begin
   comd:='GMD|17';
    IdUDPServer1.Bindings[0].SendTo( IdUDPServer1.Bindings[0].IP,IdUDPServer1.Bindings[0].Port,comd[1],Length(comd));
   fRecvUDPstring:='';
   Application.ProcessMessages;
   aDateTime := Now;
    while (Now < IncMilliSecond(aDateTime, 1000 )) do //ѯʱû
    begin
        Application.ProcessMessages;
        if fRecvUDPstring <> '' then
        begin
           ecode:=Copy(fRecvUDPstring,1,1);
           if(ecode='A')then
           begin
            t:=Pos('|',fRecvUDPstring);
            if(Copy(fRecvUDPstring,t+1,2)='17')then
            md:=Copy(fRecvUDPstring,2,t-2);
            i:=3;
            Break;
           end;

        end;
    end;
    i:=i+1;
  end;

  i:=0;
  while(i<3)do
  begin
   comd:='GDI|18';
    IdUDPServer1.Bindings[0].SendTo( IdUDPServer1.Bindings[0].IP,IdUDPServer1.Bindings[0].Port,comd[1],Length(comd));
   fRecvUDPstring:='';
   Application.ProcessMessages;
   aDateTime := Now;
    while (Now < IncMilliSecond(aDateTime, 1000 )) do //ѯʱû
    begin
        Application.ProcessMessages;
        if fRecvUDPstring <> '' then
        begin
           ecode:=Copy(fRecvUDPstring,1,1);
           if(ecode='A')then
           begin
            t:=Pos('|',fRecvUDPstring);
            if(Copy(fRecvUDPstring,t+1,2)='18')then
            di:=Copy(fRecvUDPstring,2,t-2);
            i:=3;
            Break;
           end;

        end;
    end;
    i:=i+1;
  end;

  i:=0;
  while(i<3)do
  begin
   comd:='GDP|19';
    IdUDPServer1.Bindings[0].SendTo( IdUDPServer1.Bindings[0].IP,IdUDPServer1.Bindings[0].Port,comd[1],Length(comd));
   fRecvUDPstring:='';
   Application.ProcessMessages;
   aDateTime := Now;
    while (Now < IncMilliSecond(aDateTime, 1000 )) do //ѯʱû
    begin
        Application.ProcessMessages;
        if fRecvUDPstring <> '' then
        begin
           ecode:=Copy(fRecvUDPstring,1,1);
           if(ecode='A')then
           begin
            t:=Pos('|',fRecvUDPstring);
            if(Copy(fRecvUDPstring,t+1,2)='19')then
            dp:=Copy(fRecvUDPstring,2,t-2);
            i:=3;
            Break;
           end;

        end;
    end;
    i:=i+1;
  end;

  i:=0;
  while(i<3)do
  begin
   comd:='GGI|20';
    IdUDPServer1.Bindings[0].SendTo( IdUDPServer1.Bindings[0].IP,IdUDPServer1.Bindings[0].Port,comd[1],Length(comd));
   fRecvUDPstring:='';
   Application.ProcessMessages;
   aDateTime := Now;
    while (Now < IncMilliSecond(aDateTime, 1000 )) do //ѯʱû
    begin
        Application.ProcessMessages;
        if fRecvUDPstring <> '' then
        begin
           ecode:=Copy(fRecvUDPstring,1,1);
           if(ecode='A')then
           begin
            t:=Pos('|',fRecvUDPstring);
            if(Copy(fRecvUDPstring,t+1,2)='20')then
            gi:=Copy(fRecvUDPstring,2,t-2);
            i:=3;
            Break;
           end;

        end;
    end;
    i:=i+1;
  end;

  i:=0;
  while(i<3)do
  begin
   comd:='GNM|21';
   IdUDPServer1.Bindings[0].SendTo( IdUDPServer1.Bindings[0].IP,IdUDPServer1.Bindings[0].Port,comd[1],Length(comd));
   fRecvUDPstring:='';
   Application.ProcessMessages;
   aDateTime := Now;
    while (Now < IncMilliSecond(aDateTime, 1000 )) do //ѯʱû
    begin
        Application.ProcessMessages;
        if fRecvUDPstring <> '' then
        begin
           ecode:=Copy(fRecvUDPstring,1,1);
           if(ecode='A')then
           begin
            t:=Pos('|',fRecvUDPstring);
            if(Copy(fRecvUDPstring,t+1,2)='21')then
            nm:=Copy(fRecvUDPstring,2,t-2);
            i:=3;
            Break;
           end;
        end;
    end;
    i:=i+1;
  end;
  if(''=nm) or (''=mac) or (''=IP) or (''=portnum) or (''=br)
     or (''=bb) or (''=dt) or (''=rm) or (''=tup) or (''=pr)
     or (''=fc) or (''=di) or (''=dp) or (''=gi) then
  begin
	   MessageDlg('Please check device and PC connection status!', mtWarning, [mbOK], 0);
     Exit;
  end;
  with fSetdlg do
  begin
    Edit1.Text:=usename;
    Edit2.Text:=dsname;
    Edit3.Text:=mac;
    Edit4.Text:=IP;
    Edit5.Text:=portnum;
    ComboBox1.ItemIndex:=StrToInt(tup);
    ComboBox2.ItemIndex:=StrToInt(rm);
    Edit6.Text:=di;
    Edit7.Text:=dp;
    Edit8.Text:=gi;
    Edit9.Text:=nm;
    ComboBox3.ItemIndex:=StrToInt(br);
    ComboBox4.ItemIndex:=StrToInt(pr);
    ComboBox5.ItemIndex:=StrToInt(bb);
    ComboBox6.ItemIndex:=StrToInt(dt);
    ComboBox7.ItemIndex:=StrToInt(fc);
    if(ComboBox2.ItemIndex=0)then
    begin
      Edit6.Enabled:=False;
      Edit7.Enabled:=False;
      Edit8.Enabled:=False;
      Edit9.Enabled:=False;
      Button1.Enabled:=False;
    end
    else
    begin
      Edit6.Enabled:=True;
      Edit7.Enabled:=True;
      Edit8.Enabled:=True;
      Edit9.Enabled:=True;
      Button1.Enabled:=True;
    end;
  end;
  fNhSetDlg.ComboBox1.ItemIndex:=StrToInt(frmUHFReader188demomain.cm);
  fNhSetDlg.ComboBox2.ItemIndex:=StrToInt(frmUHFReader188demomain.ct);

  fPhSetDlg.Edit1.Text:=frmUHFReader188demomain.ml;
  fPhSetDlg.Edit2.Text:=frmUHFReader188demomain.md;
  fPhSetDlg.ComboBox1.ItemIndex:=StrToInt(frmUHFReader188demomain.rc);
  frmUHFReader188demomain.Enabled:=False;
  fSetdlg.Show;
end;

procedure TfrmUHFReader188demomain.Button24Click(Sender: TObject);
var
  select_index:Integer;
  comd:string;
  aDateTime: TDateTime;
  hexstr,str,str1:string;
  i,t,dwNo,bOpt:integer;
  ecode:string;
  aListItem:TListItem;
begin
  if ListView1.Selected = nil then
  begin
    MessageDlg('No select device', mtWarning, [mbOK], 0);
    exit;
  end;
  if ListView1.Selected.SubItems[0]<>''then
  begin
    IP:=ListView1.Selected.SubItems[1];
    mac:= ListView1.Selected.SubItems[0];
    select_index:= ListView1.Selected.Index;
  end
  else
  begin
    Exit;
  end;
  try
    IdUDPServer1.DefaultPort:=0;
    IdUDPServer1.Active:=True;
  except
    MessageDlg('Service port conflict!', mtInformation, [mbOK], 0);
  end;
  IdUDPServer1.Bindings[0].IP:='255.255.255.255';
  IdUDPServer1.Bindings[0].Port:=65535;

  i:=0;
  while(i<3)do
  begin
   comd:='B';
   IdUDPServer1.Bindings[0].SendTo(IdUDPServer1.Bindings[0].IP,IdUDPServer1.Bindings[0].Port,comd[1],Length(comd));
   fRecvUDPstring:='';
   aDateTime := Now;
    while (Now < IncMilliSecond(aDateTime, 1000 )) do //ѯʱû
    begin
        Application.ProcessMessages;
        if fRecvUDPstring <> '' then
        begin
           ecode:=Copy(fRecvUDPstring,1,1);
           if(ecode='A')then
           begin
              mac:=Copy(fRecvUDPstring,2,Pos('/',fRecvUDPstring)-2);
              IP:= RemostIP;
              t :=Pos('*',fRecvUDPstring)+8;
              str1:=Copy(fRecvUDPstring,t,Length(fRecvUDPstring)-t+1)   ;
              t:=Pos('/',str1);
              usename:=Copy(str1,1,t-1);
              dsname:=Copy(str1,t+1,Length(str1)-t+1);
              i:=3;
              Break;
           end;
        end;
    end;
    i:=i+1;
  end;
end;

procedure TfrmUHFReader188demomain.IdUDPServer1UDPRead(Sender: TObject;
  AData: TStream; ABinding: TIdSocketHandle);
var DataStringStream:tstringstream;
begin
  //tstringstream࣬Ҫsocketдݴַ
 DataStringStream:=tstringstream.Create('');
 TRY
   DataStringStream.CopyFrom(adata,adata.Size);
   fRecvUDPstring:=DataStringStream.DataString;
   RemostIP:= ABinding.PeerIP;
 finally
   DataStringStream.Free;
 end;
end;

procedure TfrmUHFReader188demomain.RD_PortClick(Sender: TObject);
begin
 Button2.Enabled:=True;
  Button4.Enabled:=True;
  opnet.Enabled:=False;
  closenet.Enabled:=False;
  closenetClick(Sender);
end;

procedure TfrmUHFReader188demomain.RD_NetClick(Sender: TObject);
begin
 Button2.Enabled:=False;
  Button4.Enabled:=False;
  opnet.Enabled:=True;
  closenet.Enabled:=True;
  Action_CloseCOMExecute(Sender);
end;

procedure TfrmUHFReader188demomain.opnetClick(Sender: TObject);
var
  Port:LongInt;
  IPaddr:string;
  openresult:LongInt;
begin
  Screen.Cursor := crHourGlass;
  try
    if(Edit6.Text='')then
    Exit;
    if(Edit7.Text='')then
    Exit;
    if(Edit8.Text='')then
    Exit;
    fComAdr := StrToInt('$' + Edit8.Text);
    Port:= StrToInt(Edit6.Text);
    IPaddr:=Trim(Edit7.Text);
    openresult:=OpenNetPort(Port,IPaddr,fComAdr,frmcomportindex) ;
    fOpenComIndex := frmcomportindex;
    if(openresult=0)then
    begin
      Action_GetReaderInformationExecute(Sender); //ԶִжȡдϢ
      ComIsOpen:=True;
    end;
  finally
    Screen.Cursor := crDefault;
  end;
  if (fOpenComIndex <> -1) and
     (openresult <> $35)  and
     (openresult <> $30)  then
  begin

  end;
  if fOpenComIndex = -1 then
  begin
    Application.MessageBox('Communication error', 'Information', MB_ICONINFORMATION);
  end;
end;

procedure TfrmUHFReader188demomain.closenetClick(Sender: TObject);
begin
  if(frmcomportindex<0)then Exit;
  ClearLastInfo;
  fCmdRet:=CloseNetPort(frmcomportindex);
  if(fCmdRet=0)then
  begin                             
    frmcomportindex:=-1;
    fOpenComIndex := -1;
    ComIsOpen:=False;
    fOpenComIndex := -1;
    SpeedButton2.Down:=False;
    Button9.Enabled:=False;
    SpeedButton2.Caption:='Get';
    SpeedButton2.Enabled:=False;
    Timer1.Enabled:=False;
  end;
end;

procedure TfrmUHFReader188demomain.IdUDPServer2UDPRead(Sender: TObject;
  AData: TStream; ABinding: TIdSocketHandle);
var
  DataStringStream:tstringstream;
  comd:string;
  aDateTime: TDateTime;
  hexstr,str,str1:string;
  i,t,dwNo,bOpt:integer;
  ecode:string;
  aListItem:TListItem;
begin
  //tstringstream࣬Ҫsocketдݴַ
  DataStringStream:=tstringstream.Create('');
  TRY
   DataStringStream.CopyFrom(adata,adata.Size);
   fRecvUDPstring:=DataStringStream.DataString;
   RemostIP:= ABinding.PeerIP;
  finally
   DataStringStream.Free;
  end;
 //Application.ProcessMessages;
  if fRecvUDPstring <> '' then
  begin
    ecode:=Copy(fRecvUDPstring,1,1);
    if(ecode<>'A')then
    begin
     GeteCodeDesc(ecode);
     Exit;
    end;
    str:=Copy(fRecvUDPstring,2,Pos('/',fRecvUDPstring)-2);
    if(ListView1.Items.Count>0)then
    begin
     for i:=0 to ListView1.Items.Count-1 do
     if(ListView1.Items[i].SubItems[0]=str)then
     Exit;
    end;
    dwNo:=ListView1.Items.Count;
    aListItem := ListView1.Items.Add;
    aListItem.SubItems.Add('');
    aListItem.SubItems.Add('');
    aListItem.SubItems.Add('');//
    aListItem.SubItems.Add('');//
    aListItem.Caption:=IntToStr(ListView1.Items.Count);
    ListView1.Items[dwNo].SubItems[0]:=str;
    IP:= RemostIP;
    ListView1.Items[dwNo].SubItems[1]:=IP;
    t :=Pos('*',fRecvUDPstring)+8;
    str1:=Copy(fRecvUDPstring,t,Length(fRecvUDPstring)-t+2)   ;
    t:=Pos('/',str1);
    usename:=Copy(str1,1,t-1);
    dsname:=Copy(str1,t+1,Length(str1)-t+1);
    str:='';
    if((usename = '') and (dsname = '' ))or (dsname = '/')then
     str:=''
    else
    begin
     str:= usename+'/'+dsname;
    end;
    ListView1.Items[dwNo].SubItems[2]:=str;
  end;
end;

procedure TfrmUHFReader188demomain.Button10Click(Sender: TObject);
var
  Qvalue,Session:Byte;
begin
   Qvalue:=Com_Q.ItemIndex;
   Session:=Com_S.ItemIndex;
   fCmdRet:=SetQS(fComAdr,Qvalue,Session,frmcomportindex);
   AddCmdLog('SetQS','Set',fCmdRet);
end;

procedure TfrmUHFReader188demomain.Button18Click(Sender: TObject);
var
   Qvalue,Session:Byte;
begin
   fCmdRet:=GetQS(fComAdr,Qvalue,Session,frmcomportindex);
   if(fCmdRet=0)then
   begin
      Com_Q.ItemIndex:=Qvalue;
      Com_S.ItemIndex:=Session;
   end;
   AddCmdLog('GetQS','Get',fCmdRet);
end;

procedure TfrmUHFReader188demomain.Button19Click(Sender: TObject);
var
  SeriaNo:array[0..4]of Char;
  temp:string;
begin             
  fCmdRet:=GetSerialNo(fComAdr,SeriaNo,frmComPortindex);
  if(fCmdRet=0)then
  begin
    temp:=getStr(SeriaNo,4);
    Edit11.Text:=getHexStr(temp);
  end;
  AddCmdLog('GetSeriaNo', 'Get', fCmdRet);
end;

end.




